/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique;

import java.io.Serializable;

public class DomaineEntier
implements Serializable {
    private int min;
    private int max;
    private int taille;
    private int rayon;

    public DomaineEntier(int min, int max) {
        if (min > max) {
            throw new RuntimeException("DomaineEntier, DomaineEntier (int min, int max) : min > max.");
        }
        this.min = min;
        this.max = max;
        this.taille = max - min + 1;
        this.rayon = this.taille == 1 ? 0 : (this.taille < 21 ? this.taille / 10 + 1 : (int)Math.log(this.taille));
    }

    public DomaineEntier(int min, int max, int rayon) {
        if (min > max) {
            throw new RuntimeException("DomaineEntier, DomaineEntier (int min, int max, int rayon) : min > max.");
        }
        this.min = min;
        this.max = max;
        this.taille = max - min + 1;
        this.rayon = rayon;
    }

    public void setMin(int nb) {
        if (nb > this.max) {
            throw new RuntimeException("DomaineEntier, setMin (int nb) : nb est > a la borne superieure du domaine.");
        }
        this.min = nb;
        this.taille = this.max - nb + 1;
    }

    public void setMax(int nb) {
        if (nb < this.min) {
            throw new RuntimeException("DomaineEntier, setMax (int nb) : nb est < a la borne inferieure du domaine.");
        }
        this.max = nb;
        this.taille = nb - this.min + 1;
    }

    public void setRayon(int nb) {
        this.rayon = nb;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getRayon() {
        return this.rayon;
    }

    public int getTaille() {
        return this.taille;
    }
}

