% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/format_R_source_code.R
\name{format_R_source_code}
\alias{format_R_source_code}
\title{Formats R source code.}
\usage{
format_R_source_code(source, formatR_arguments = list(),
  remove_trailing_whitespace = TRUE, spaced_operators = c("/", "\%\%",
  "\%/\%", ":", "^"))
}
\arguments{
\item{source}{String with source code to format. This not the filename of the
source file.}

\item{formatR_arguments}{List of arguments passed to
\href{http://yihui.name/formatR}{formatR} via its
\code{\link[formatR]{tidy_source}}.}

\item{remove_trailing_whitespace}{Boolean: should horizontal whitespace at
the end of lines be removed?}

\item{spaced_operators}{Vector of strings with operators around which spaces
    are forced.}
}
\value{
String with formatted source code.
}
\description{
\code{format_R_source_code} is very much based on
\href{http://yihui.name/formatR}{formatR}, but tries to improve it by
heuristics. For example, spaces can be forced around the division operator
\code{/}.
}
\examples{
format_R_source_code("if (b) { f() }")
format_R_source_code("if (b) { f()\\n\\nf() }")
format_R_source_code("p = 2", list(arrow = TRUE, width.cutoff = 80))
format_R_source_code("e^x", spaced_operators = c("/"))

\dontrun{
format_R_source_code("f()", text = NULL)
format_R_source_code("f()", output = TRUE)
}
}
\seealso{
\code{\link[formatR]{tidy_source}}
}

