/*
 * Decompiled with CFR 0.152.
 */
package freak.core.population;

import freak.core.control.Schedule;
import freak.core.mapper.Mapper;
import freak.core.population.Genotype;
import java.io.Serializable;
import java.util.LinkedList;

public class Individual
implements Cloneable,
Serializable {
    public static final int INHERITABLE = 0;
    public static final int NOT_INHERITABLE = 1;
    private LinkedList tags;
    private Genotype genotype;
    private Genotype phenotype;
    private int dateOfBirth;
    private Schedule schedule;
    private Double[] latestKnownFitnessValue;

    public Individual(Schedule schedule, Genotype genotype, Individual[] parents) {
        if (schedule == null || genotype == null) {
            throw new NullPointerException("Some of the construction parameters are null.");
        }
        this.schedule = schedule;
        this.genotype = genotype;
        this.dateOfBirth = schedule.getCurrentGeneration();
        this.tags = new LinkedList();
        if (parents != null) {
            int i = 0;
            while (i < parents.length) {
                for (Tag tag : parents[i].tags) {
                    if (tag.type != 0 || this.tags.contains(tag)) continue;
                    this.addTag(tag.key, tag.value, 0);
                }
                ++i;
            }
        }
    }

    public void setDateOfBirth(int i) {
        this.dateOfBirth = i;
    }

    public int getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Genotype getGenotype() {
        return this.genotype;
    }

    public void setGenotype(Genotype genotype) {
        this.genotype = genotype;
        this.phenotype = null;
    }

    public Genotype getPhenotype() {
        if (this.phenotype != null) {
            return this.phenotype;
        }
        Mapper mapper = this.schedule.getMapper();
        if (mapper == null) {
            return this.genotype;
        }
        this.phenotype = mapper.genotypeToPhenotype(this.genotype);
        return this.phenotype;
    }

    public void addTag(Object key, Object value, int type) {
        this.tags.add(new Tag(key, value, type));
    }

    public Object getTag(Object key) {
        for (Tag tag : this.tags) {
            if (!tag.key.equals(key)) continue;
            return tag.value;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("date of birth: " + this.getDateOfBirth() + "; ");
        s.append("genotype: " + this.getGenotype().toString() + "; ");
        if (this.schedule.getMapper() != null) {
            s.append("phenotype: " + this.getPhenotype().toString() + "; ");
        }
        if (this.tags == null || this.tags.isEmpty()) {
            s.append("no tags.");
        } else {
            s.append("tags: " + this.tags.toString());
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Individual)) {
            return false;
        }
        Individual individual = (Individual)o;
        return this.genotype.equals(individual.genotype) && this.getDateOfBirth() == individual.getDateOfBirth() && this.tags.equals(individual.tags);
    }

    public int hashCode() {
        return this.getGenotype().hashCode() ^ this.tags.hashCode() ^ this.getDateOfBirth();
    }

    public Object clone() {
        Individual individual = new Individual(this.schedule, this.genotype, new Individual[]{this});
        individual.phenotype = this.phenotype;
        individual.setDateOfBirth(this.getDateOfBirth());
        return individual;
    }

    public void setLatestKnownFitnessValue(Double[] fitness) {
        this.latestKnownFitnessValue = fitness;
    }

    public Double[] getLatestKnownFitnessValue() {
        return this.latestKnownFitnessValue;
    }

    private class Tag
    implements Serializable {
        public Object key;
        public Object value;
        public int type;

        public Tag(Object key, Object value, int type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Tag)) {
                return false;
            }
            return ((Tag)o).key.equals(((Tag)o).key);
        }
    }
}

