/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class Ridge
extends AbstractStaticSingleObjectiveFitnessFunction {
    public Ridge(Schedule schedule) {
        super(schedule);
    }

    public double evaluate(Genotype genotype) {
        boolean isOfSpecialForm;
        BitSet bitSet = ((BitStringGenotype)genotype).getBitSet();
        int dimension = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        int cardinality = bitSet.cardinality();
        int leadingOnes = 0;
        while (leadingOnes < dimension) {
            if (!bitSet.get(leadingOnes)) break;
            ++leadingOnes;
        }
        boolean bl = isOfSpecialForm = cardinality - leadingOnes == 0;
        if (isOfSpecialForm) {
            return dimension + leadingOnes;
        }
        return dimension - cardinality;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return 2 * ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }

    public String getDescription() {
        return "Contains a path of neighbored search points with strictly monotone fitness values which has to be climbed to reach the optimum. The path consists of all individuals with all ones in the left part and all zeros in the right part of the genotype. The start of the path contains only zeros and the global optimum contains only ones.\nThe fitness value for an individual on the path is n + OneMax.\nThe fitness value for all other individuals is n-OneMax, thus giving hints to reach the start of the path.";
    }

    public String getName() {
        return "Ridge";
    }
}

