/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class HyperCube
extends AbstractView
implements Configurable,
FreakSwingModel {
    private transient JPanel panel;
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private static Color DEFAULT_COLOR = Color.red;
    private IndividualList individuals;
    private boolean colorByFitness;
    private boolean displayOptimum = this.supportsDisplayOptimum();
    private int maximalNumberOfIndividuals = 1000;

    public HyperCube(Schedule schedule) {
        super(schedule);
        this.colorByFitness = this.supportsUseColor();
    }

    public void initialize() {
        super.initialize();
        this.displayOptimum &= this.supportsDisplayOptimum();
        this.colorByFitness &= this.supportsUseColor();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof BitString)) {
            throw new UnsupportedEnvironmentException("Unsupported searchspace.");
        }
    }

    public JPanel createPanel() {
        this.panel = new HyperCubePanel(this);
        return this.panel;
    }

    private boolean supportsUseColor() {
        if (!(this.getSchedule().getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            return false;
        }
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        try {
            fitness.getLowerBound();
            fitness.getUpperBound();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private boolean supportsDisplayOptimum() {
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        try {
            fitness.getGenotypeOptimum();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        super.update(data);
        HyperCube hyperCube = this;
        synchronized (hyperCube) {
            this.individuals = (IndividualList)data;
        }
        UpdateManager.markDirty(this);
    }

    public void flush() {
        if (this.panel == null) {
            return;
        }
        this.panel.repaint();
    }

    public String getName() {
        return "Boolean Hypercube";
    }

    public String getDescription() {
        return "A schematic visualization of a boolean hypercube.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public Color getColorByFitness(Individual individual) {
        if (!this.colorByFitness) {
            return DEFAULT_COLOR;
        }
        try {
            SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double lowerFitnessBound = fitness.getLowerBound();
            double upperFitnessBound = fitness.getUpperBound();
            double fitnessValue = fitness.evaluate(individual, this.individuals);
            double normalizedFitnessValue = (fitnessValue - lowerFitnessBound) / (upperFitnessBound - lowerFitnessBound);
            Color result = new Color(Color.HSBtoRGB((float)(1.0 - normalizedFitnessValue) * 0.8f, SATURATION, BRIGHTNESS));
            return result;
        }
        catch (UnsupportedOperationException ex) {
            return DEFAULT_COLOR;
        }
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    public void setPropertyColorByFitness(Boolean colorByFitness) {
        this.colorByFitness = colorByFitness != false && this.supportsUseColor();
    }

    public Boolean getPropertyColorByFitness() {
        return new Boolean(this.colorByFitness);
    }

    public String getShortDescriptionForColorByFitness() {
        return "Color individuals by fitness";
    }

    public String getLongDescriptionForColorByFitness() {
        return "Colors the displayed individuals by their fitness on a scale from violet (least fitness) to red (highest fitness). This feature can only be enabled if the fitness function knows the optimal fitness value.";
    }

    public void setPropertyDisplayOptimum(Boolean displayOptimum) {
        this.displayOptimum = displayOptimum != false && this.supportsDisplayOptimum();
    }

    public Boolean getPropertyDisplayOptimum() {
        return new Boolean(this.displayOptimum);
    }

    public String getShortDescriptionForDisplayOptimum() {
        return "Display global optimum";
    }

    public String getLongDescriptionForDisplayOptimum() {
        return "Displays the global optimum in the hypercube. This option can only be enabled if a global optimum exists and if the fitness function knows the optimum.";
    }

    public void setPropertyMaximalNumberOfIndividuals(Integer number) {
        if (number > 0) {
            this.maximalNumberOfIndividuals = number;
        }
    }

    public Integer getPropertyMaximalNumberOfIndividuals() {
        return new Integer(this.maximalNumberOfIndividuals);
    }

    public String getShortDescriptionForMaximalNumberOfIndividuals() {
        return "Maximal number of individuals";
    }

    public String getLongDescriptionForMaximalNumberOfIndividuals() {
        return "Sets the maximal number of individuals displayed in the hypercube. If more individuals are to be displayed, only the first ones are shown.";
    }

    class HyperCubePanel
    extends JPanel {
        public static final double X_SCALE = 0.8;
        public static final int MAX_POINT_SIZE = 8;
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private HyperCube hyperCube;

        public HyperCubePanel(HyperCube hyperCube2) {
            this.hyperCube = hyperCube2;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            g.setColor(Color.black);
            this.drawSearchSpace();
            HyperCube hyperCube = this.hyperCube;
            synchronized (hyperCube) {
                IndividualList individuals = this.hyperCube.getIndividualList();
                if (individuals != null) {
                    Iterator iter = individuals.iterator();
                    int counter = 0;
                    while (iter.hasNext() && counter < HyperCube.this.maximalNumberOfIndividuals) {
                        Individual individual = (Individual)iter.next();
                        g.setColor(this.hyperCube.getColorByFitness(individual));
                        this.drawIndividual(((BitStringGenotype)individual.getGenotype()).getBooleanArray());
                        ++counter;
                    }
                }
                if (this.hyperCube.displayOptimum) {
                    try {
                        Genotype optimum = this.hyperCube.getSchedule().getFitnessFunction().getGenotypeOptimum();
                        this.drawOptimum(((BitStringGenotype)optimum).getBooleanArray());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        private void drawSearchSpace() {
            this.graphics.setColor(Color.black);
            int centerx = this.insets.left + this.currentWidth / 2;
            int y = 0;
            while (y <= this.currentHeight) {
                int xdev = this.getXDeviation(y);
                this.drawPixel(centerx - xdev, y + this.insets.top);
                this.drawPixel(centerx + xdev, y + this.insets.top);
                ++y;
            }
        }

        private int getXDeviation(int y) {
            return (int)(Math.sin(Math.PI * ((double)y / (double)this.currentHeight)) * this.getXScale());
        }

        private double getXScale() {
            return (double)this.currentWidth * 0.4;
        }

        private Point getDisplayCoordinates(boolean[] b) {
            int onemax = 0;
            int i = 0;
            while (i < b.length) {
                if (b[i]) {
                    ++onemax;
                }
                ++i;
            }
            int sumOfIndices = 0;
            int i2 = 0;
            while (i2 < b.length) {
                if (b[i2]) {
                    sumOfIndices += i2;
                }
                ++i2;
            }
            int minimalSumOfIndices = (onemax - 1) * onemax / 2;
            int maximalSumOfIndices = (b.length - 1) * b.length / 2 - (b.length - 1 - onemax) * (b.length - onemax) / 2;
            int range = maximalSumOfIndices - minimalSumOfIndices;
            int x = 2 * sumOfIndices - 2 * minimalSumOfIndices - range;
            int centerX = this.insets.left + this.currentWidth / 2;
            int yOffset = (int)((double)((b.length - onemax) * this.currentHeight) / (double)b.length);
            int xOffset = 0;
            if (range != 0) {
                xOffset = (int)((double)(x * this.getXDeviation(yOffset)) / (double)range);
            }
            return new Point(centerX + xOffset, yOffset + this.insets.top);
        }

        private void drawIndividual(boolean[] b) {
            int radius = this.getPointSize();
            Point point = this.getDisplayCoordinates(b);
            this.graphics.fillOval((int)point.getX() - (radius + 1) / 2 + 1, (int)point.getY() - (radius + 1) / 2, radius, radius);
        }

        private void drawOptimum(boolean[] b) {
            int length = this.getPointSize() * 2 / 3;
            Point point = this.getDisplayCoordinates(b);
            this.graphics.setColor(Color.blue);
            this.graphics.drawLine((int)point.getX() - length, (int)point.getY() - length, (int)point.getX() + length, (int)point.getY() + length);
            this.graphics.drawLine((int)point.getX() - length, (int)point.getY() + length, (int)point.getX() + length, (int)point.getY() - length);
            this.graphics.drawLine((int)point.getX(), (int)point.getY() - length, (int)point.getX(), (int)point.getY() + length);
            this.graphics.drawLine((int)point.getX() - length, (int)point.getY(), (int)point.getX() + length, (int)point.getY());
        }

        private void drawPixel(int x, int y) {
            this.graphics.drawLine(x - 1, y, x + 1, y);
        }

        private int getPointSize() {
            return Math.max(1, Math.min(8, this.currentHeight / 50));
        }
    }
}

