/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.math;

import freak.module.fitness.pointset.math.ConjugrateGradientSolver;
import freak.module.fitness.pointset.math.EquationSolver;
import freak.module.fitness.pointset.math.matrix.Matrix;
import freak.module.fitness.pointset.math.matrix.Vector;
import freak.module.fitness.pointset.math.matrix.view.NormalView;
import freak.module.fitness.pointset.math.matrix.view.VectorView;

public class EqSolvers
extends EquationSolver {
    NormalView mat = new NormalView(this.A);
    VectorView b = new VectorView(this.B);
    EquationSolver aktSolver = null;

    public EqSolvers(int dimension) {
        super(dimension);
        try {
            this.aktSolver = new ConjugrateGradientSolver(this.A, this.B);
        }
        catch (Exception e) {
            throw new Error("Unsupported Error in EqSolvers(int)");
        }
    }

    public EqSolvers(Matrix m, Vector b) throws Exception {
        super(m, b);
        try {
            this.aktSolver = new ConjugrateGradientSolver(this.A, this.B);
        }
        catch (Exception e) {
            throw new Error("Unsupported Error in EqSolvers(int)");
        }
    }

    public void setA(int r, int c, double v) {
        try {
            this.mat.set(r, c, v);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void setB(int k, double v) {
        try {
            this.b.set(k, v);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    void solve(NormalView pMat, VectorView pB) throws Exception {
        this.aktSolver.solve(pMat, pB);
        this.result = this.aktSolver.result;
    }

    protected boolean willSolveChangeTheMatrix() {
        return this.aktSolver.willSolveChangeTheMatrix();
    }

    public static void main(String[] args) {
        System.out.println("Testumgebung EqSolvers");
        int d = 2;
        EqSolvers solver = new EqSolvers(d);
        solver.setA(0, 0, 3.0);
        solver.setA(0, 1, 4.0);
        solver.setB(0, 2.0);
        solver.setA(1, 0, -2.0);
        solver.setA(1, 1, 1.0);
        solver.setB(1, 1.0);
        VectorView resView = null;
        try {
            Vector result = solver.solve();
            resView = new VectorView(result);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        int i = 0;
        while (i < d) {
            try {
                System.out.println("res[" + i + "]: " + resView.get(i));
            }
            catch (Exception e) {
                throw new Error(e);
            }
            ++i;
        }
    }
}

