/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.services;

import edu.ucsb.cs.jicos.foundation.Service;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.Host;
import edu.ucsb.cs.jicos.services.HspProxy;
import edu.ucsb.cs.jicos.services.JoinCounter;
import edu.ucsb.cs.jicos.services.PQTasks;
import edu.ucsb.cs.jicos.services.Result;
import edu.ucsb.cs.jicos.services.SessionInfo;
import edu.ucsb.cs.jicos.services.SessionStatistics;
import edu.ucsb.cs.jicos.services.Task;
import edu.ucsb.cs.jicos.services.TaskId;
import edu.ucsb.cs.jicos.services.TaskInfo;
import edu.ucsb.cs.jicos.services.TaskServer;
import edu.ucsb.cs.jicos.services.commands.ExecuteTask;
import edu.ucsb.cs.jicos.services.commands.PutResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Session {
    private static final int TASKS_INITIAL_CAPACITY = 1024;
    private static final boolean executeOn = true;
    private TaskServer taskserver;
    private Host internalHost;
    private SessionInfo sessionInfo;
    private Map tasks = Collections.synchronizedMap(new HashMap(1024));
    private PQTasks unassignedTasks;
    private SessionStatistics sessionStatistics = new SessionStatistics();
    private JoinCounter joinCounter = new JoinCounter();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$services$Session;

    Session(TaskServer taskServer, Host host) {
        this.taskserver = taskServer;
        this.internalHost = host;
        this.unassignedTasks = new PQTasks(taskServer);
    }

    void assign(Task task, Service service) {
        task.setHost(service);
    }

    synchronized void clear() {
        this.sessionInfo = null;
        this.tasks.clear();
        this.unassignedTasks.clear();
        this.sessionStatistics = new SessionStatistics();
        this.joinCounter.reset();
    }

    JoinCounter getJoinCounter() {
        return this.joinCounter;
    }

    SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    SessionStatistics getSessionStatistics() {
        return this.sessionStatistics;
    }

    TaskServer taskserver() {
        return this.taskserver;
    }

    PQTasks unassignedTasks() {
        return this.unassignedTasks;
    }

    void loginClient(SessionInfo sessionInfo) {
        if (!$assertionsDisabled && sessionInfo == null) {
            throw new AssertionError();
        }
        this.sessionInfo = sessionInfo;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void processCompletedTask(TaskInfo var1_1) {
        block2: {
            var2_2 = var1_1.taskId();
            var3_3 = var1_1.getSuccessorTaskId();
            var4_4 = var1_1.getSuccessorIndex();
            var5_5 = var1_1.getValue();
            var6_6 = var1_1.getChildren();
            var7_7 = var1_1.getCriticalPathTime();
            if (var6_6 == null && var3_3 != null) {
                this.setArg(var3_3, var4_4, var5_5, var7_7);
            }
            if (var6_6 == null) break block2;
            this.spawn((Task)var6_6.remove(var6_6.size() - 1));
            if (Session.$assertionsDisabled || var6_6.size() > 0) ** GOTO lbl17
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                var9_8 = (Task)var6_6.remove(0);
                var9_8.setTaskServer(this.taskserver);
                var9_8.taskServerServiceName(this.taskserver.serviceName());
                this.spawn(var9_8);
lbl17:
                // 2 sources

                ** while (var6_6.size() > 0)
            }
        }
        this.tasks.remove(var2_2);
    }

    public synchronized void processResult(TaskInfo taskInfo) {
        TaskId taskId = taskInfo.taskId();
        if (!$assertionsDisabled && taskId == null) {
            throw new AssertionError();
        }
        if (this.sessionInfo == null || this.sessionInfo.getSessionId() != taskId.getSessionId()) {
            System.out.println("Session.processResult: Ignoring old TaskInfo.");
            return;
        }
        this.processCompletedTask(taskInfo);
    }

    synchronized void receiveTasks(Task[] taskArray) {
        int n = 0;
        while (n < taskArray.length) {
            this.tasks.put(taskArray[n].getTaskId(), taskArray[n]);
            this.unassignedTasks.put(taskArray[n]);
            ++n;
        }
    }

    Task requestTask(Service service) {
        Task task = this.unassignedTasks.remove();
        this.assign(task, service);
        return task;
    }

    Task[] requestTasks(int n) {
        Task[] taskArray = this.unassignedTasks.removeTasks(n);
        int n2 = 0;
        while (n2 < taskArray.length) {
            Task task = (Task)this.tasks.remove(taskArray[n2].getTaskId());
            if (!$assertionsDisabled && task == null) {
                throw new AssertionError();
            }
            ++n2;
        }
        return taskArray;
    }

    public synchronized void setArg(TaskId taskId, int n, Object object, long l) {
        if (!$assertionsDisabled && taskId == null) {
            throw new AssertionError();
        }
        if (n == -1) {
            Result result = new Result(taskId, object, l);
            PutResult putResult = new PutResult(taskId, result);
            HspProxy hspProxy = this.taskserver.hspProxy();
            hspProxy.execute(putResult);
        } else {
            Task task = (Task)this.tasks.get(taskId);
            if (!$assertionsDisabled && task == null) {
                throw new AssertionError((Object)("No successor Task found: " + taskId));
            }
            if (!$assertionsDisabled && task.get$UnsetArgs() == 0) {
                throw new AssertionError((Object)"Successor: no unset arguments");
            }
            if (task.getPredecessorCriticalPathTime() < l) {
                task.setPredecessorCriticalPathTime(l);
            }
            task.setInput(n, object);
            if (task.decr$UnsetArgs() == 0) {
                Environment environment = this.sessionInfo.getEnvironment();
                if (task.executeOnServer(environment)) {
                    ExecuteTask executeTask = new ExecuteTask(task);
                    this.internalHost.computeDepartment().addCommand(executeTask);
                } else {
                    this.unassignedTasks.put(task);
                }
            }
        }
    }

    synchronized void setInfo(SessionInfo sessionInfo) {
        if (!$assertionsDisabled && sessionInfo == null) {
            throw new AssertionError();
        }
        this.sessionInfo = sessionInfo;
    }

    public synchronized void spawn(Task task) {
        if (task == null) {
            throw new IllegalArgumentException("Null task.");
        }
        this.tasks.put(task.getTaskId(), task);
        if (task.isCached()) {
            this.assign(task, task.getSpawningHost());
            return;
        }
        if (task.get$UnsetArgs() == 0) {
            this.unassignedTasks.put(task);
        }
    }

    void unassign(TaskId taskId) {
        Task task = (Task)this.tasks.get(taskId);
        if (task != null) {
            this.unassignedTasks.put(task);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$services$Session == null ? (class$edu$ucsb$cs$jicos$services$Session = Session.class$("edu.ucsb.cs.jicos.services.Session")) : class$edu$ucsb$cs$jicos$services$Session).desiredAssertionStatus();
    }
}

