/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractMultiObjectiveFitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunctionGenotype;
import java.util.Iterator;

public class DominationSelection
extends Selection
implements CompatibleWithDifferentSearchSpaces {
    public DominationSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof MultiObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This operator works on multi objective fitness functions only.");
        }
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        boolean excludeEqual = true;
        IndividualList[] result = new IndividualList[1];
        if (input[1].size() != 1) {
            throw new GraphException("The number of individuals sent to inport 2 of " + this.name + " must be exactly 1 not " + input[1].size() + ".");
        }
        MultiObjectiveFitnessFunction ff = (MultiObjectiveFitnessFunction)this.getOperatorGraph().getSchedule().getFitnessFunction();
        double[] fitness = ff.evaluate(input[1].getIndividual(0), input[0]);
        int[] comp = new int[input[0].size()];
        Iterator it = input[0].iterator();
        int i = 0;
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            double[] fitness2 = ff.evaluate(ind, input[0]);
            comp[i] = AbstractMultiObjectiveFitnessFunction.compare(fitness2, fitness);
            if (!excludeEqual && comp[i] == 0 && !ind.getGenotype().toString().equals(input[1].getIndividual(0).getGenotype().toString())) {
                comp[i] = -2;
                if (ind.getGenotype() instanceof BooleanFunctionGenotype && ((BooleanFunctionGenotype)ind.getGenotype()).getDnfbaum().getLiteralBitSet().equals(((BooleanFunctionGenotype)input[1].getIndividual(0).getGenotype()).getDnfbaum().getLiteralBitSet())) {
                    comp[i] = 0;
                }
            }
            if (comp[i] >= 0) {
                result[0] = input[0];
                return result;
            }
            ++i;
        }
        Population pop = new Population(this.getOperatorGraph().getSchedule());
        result[0] = pop;
        pop.addIndividual(input[1].getIndividual(0));
        it = input[0].iterator();
        i = 0;
        while (it.hasNext()) {
            Individual ind = (Individual)it.next();
            if (comp[i] == -2) {
                pop.addIndividual(ind);
            }
            ++i;
        }
        return result;
    }

    public String getName() {
        return "Domination Selection";
    }

    public String getDescription() {
        return "This selection operator first checks whether the newly created individuals is dominated by an individual contained in the current population or not. In the latter case the individual is added to the population and all individuals which are dominated by the new individual are removed from the population.";
    }
}

