/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport.inspector;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class FileEditor
extends DefaultCellEditor {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    private File file;
    private JButton chooserButton;
    private int action;

    public FileEditor(final int action) {
        super(new JCheckBox());
        this.action = action;
        this.setClickCountToStart(1);
        this.file = new File("");
        this.chooserButton = new JButton();
        this.chooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(FileEditor.this.file);
                int result = 1;
                switch (action) {
                    case 0: {
                        result = chooser.showOpenDialog(FileEditor.this.chooserButton);
                        break;
                    }
                    case 1: {
                        result = chooser.showSaveDialog(FileEditor.this.chooserButton);
                    }
                }
                if (result == 0) {
                    switch (action) {
                        case 0: {
                            if (chooser.getSelectedFile().exists()) {
                                FileEditor.this.file = chooser.getSelectedFile();
                                break;
                            }
                            JOptionPane.showMessageDialog(null, "File " + chooser.getSelectedFile() + " can not be found.", "File not found", 0);
                            break;
                        }
                        case 1: {
                            if (chooser.getSelectedFile().exists()) {
                                Object[] options = new Object[]{"OK", "Cancel"};
                                int answer = JOptionPane.showOptionDialog(null, "Replace existing file " + chooser.getSelectedFile() + "?", "Warning", -1, 2, null, options, options[0]);
                                if (answer != 0) break;
                                FileEditor.this.file = chooser.getSelectedFile();
                                FileEditor.this.file.delete();
                                break;
                            }
                            FileEditor.this.file = chooser.getSelectedFile();
                        }
                    }
                }
                FileEditor.this.fireEditingStopped();
            }
        });
        this.editorComponent = this.chooserButton;
    }

    public Object getCellEditorValue() {
        return this.file;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.file = (File)value;
        return this.editorComponent;
    }
}

