/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.core.control.Schedule;
import freak.core.graph.FreakEdge;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.FreakPort;
import freak.core.graph.GraphSyntaxException;
import freak.core.graph.HasFloatingNumberOfInPorts;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.InPort;
import freak.core.graph.Operator;
import freak.core.graph.OperatorGraphCell;
import freak.core.graph.OutPort;
import freak.core.graph.Port;
import freak.core.graph.PortConnectException;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleInfo;
import freak.core.modulesupport.inspector.InspectorVetoException;
import freak.gui.ConfigurationPanel;
import freak.gui.graph.EditorDialogUI;
import freak.gui.graph.FreakMarqueeHandler;
import freak.gui.graph.OperatorGraphFile;
import freak.gui.graph.ParameterControllerDialog;
import freak.gui.runframe.SingleExtensionFileFilter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;

public class EditorDialog
extends EditorDialogUI {
    private GraphModelListener graphModelListener;
    private static SingleExtensionFileFilter filter = new SingleExtensionFileFilter(".fop", "Freak Operator Graph");
    private File lastFile;

    public EditorDialog(Dialog owner, Schedule schedule) {
        super(owner, schedule);
        this.insertButton.setEnabled(false);
        this.operatorTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)EditorDialog.this.operatorTree.getLastSelectedPathComponent();
                if (node == null || !node.isLeaf()) {
                    EditorDialog.this.insertButton.setEnabled(false);
                } else {
                    EditorDialog.this.insertButton.setEnabled(true);
                }
            }
        });
        this.operatorTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DefaultMutableTreeNode node;
                int selRow = EditorDialog.this.operatorTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2 && (node = (DefaultMutableTreeNode)EditorDialog.this.operatorTree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                    EditorDialog.this.insert(null);
                    e.consume();
                }
            }
        });
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (leaf) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof ModuleInfo) {
                        String description = ((ModuleInfo)userObject).getDescription();
                        this.setToolTipText(description);
                    }
                } else {
                    this.setToolTipText(null);
                }
                return this;
            }
        };
        this.operatorTree.setCellRenderer(renderer);
        ToolTipManager.sharedInstance().registerComponent(this.operatorTree);
        this.graphModelListener = new FreakGraphModelListener(schedule);
        this.graph.setMarqueeHandler(new FreakMarqueeHandler(this.graph, this));
        this.graph.getModel().addGraphModelListener(this.graphModelListener);
        GraphLayoutCache layoutCache = this.graph.getGraphLayoutCache();
        CellView[] allViews = layoutCache.getAllDescendants(layoutCache.getRoots());
        this.graph.getGraphLayoutCache().refresh(allViews, false);
    }

    protected void insert(ActionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.operatorTree.getLastSelectedPathComponent();
        if (node == null || !node.isLeaf()) {
            throw new IllegalStateException("No leaf selected");
        }
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ModuleInfo)) {
            throw new RuntimeException("invalid operator, cannot be inserted: " + userObject);
        }
        ModuleInfo info = (ModuleInfo)userObject;
        Operator operator = this.manager.newOperator(info);
        operator.createEvents();
        OperatorGraphCell cell = new OperatorGraphCell(operator);
        Map map = cell.getAttributes();
        Point point = this.graph.snap(new Point(10, 10));
        int height = this.graph.getGraphics().getFontMetrics().getHeight();
        int width = this.graph.getGraphics().getFontMetrics().stringWidth(operator.toString());
        Dimension size = new Dimension(width + 10, height + 8);
        GraphConstants.setBounds(map, new Rectangle(point, size));
        GraphConstants.setOpaque(map, true);
        Hashtable<OperatorGraphCell, Map> attributes = new Hashtable<OperatorGraphCell, Map>();
        attributes.put(cell, map);
        Object[] toInsert = new Object[]{cell};
        this.graph.getModel().insert(toInsert, attributes, null, null, null);
        this.graph.getModel().toFront(toInsert);
        this.graph.setSelectionCells(toInsert);
    }

    protected void connect(org.jgraph.graph.Port source, org.jgraph.graph.Port target) {
        ConnectionSet cs = new ConnectionSet();
        FreakEdge edge = new FreakEdge((FreakPort)source, (FreakPort)target);
        cs.connect((Object)edge, (Object)source, target);
        Map map = GraphConstants.createMap();
        GraphConstants.setLineEnd(map, 2);
        Hashtable<FreakEdge, Map> attributes = new Hashtable<FreakEdge, Map>();
        attributes.put(edge, map);
        this.graph.getGraphLayoutCache().insert(new Object[]{edge}, attributes, cs, null, null);
    }

    protected void delete(ActionEvent e) {
        if (!this.graph.isSelectionEmpty()) {
            Object[] cells = this.graph.getSelectionCells();
            cells = this.graph.getDescendants(cells);
            Vector toRemove = new Vector(Arrays.asList(cells));
            Vector notToRemove = new Vector();
            for (Object element : toRemove) {
                if (!(element instanceof OperatorGraphCell)) continue;
                OperatorGraphCell cell = (OperatorGraphCell)element;
                if (this.graphModel.getOperatorGraph().isOperatorRemovable(cell.getOperator())) continue;
                notToRemove.addAll(Arrays.asList(this.graph.getDescendants(new Object[]{cell})));
            }
            toRemove.removeAll(notToRemove);
            for (Object tmp_element : toRemove) {
                String message;
                int answer;
                Serializable element = null;
                element = tmp_element instanceof FreakPort ? ((FreakPort)tmp_element).getPort() : (tmp_element instanceof OperatorGraphCell ? ((OperatorGraphCell)tmp_element).getOperator() : tmp_element);
                if (this.schedule.getEventController().isEventSource(element) && (answer = JOptionPane.showConfirmDialog(this, message = "There are components which need to get events from one of the operators you tried to delete.\nDo you want to continue?", "Warning", 0, 2)) == 1) {
                    return;
                }
                if (!(tmp_element instanceof OperatorGraphCell)) continue;
                OperatorGraphCell cell = (OperatorGraphCell)tmp_element;
                Iterator ports = cell.getPortIterator();
                while (ports.hasNext()) {
                    FreakPort port = (FreakPort)ports.next();
                    Iterator edges = port.edges();
                    while (edges.hasNext()) {
                        FreakEdge edge = (FreakEdge)edges.next();
                        FreakPort source = edge.getSourcePort();
                        FreakPort target = edge.getTargetPort();
                        Port sourcePort = (Port)source.getUserObject();
                        Port targetPort = (Port)target.getUserObject();
                        if (sourcePort.getOperator() instanceof HasFloatingNumberOfOutPorts && this.schedule.getEventController().isEventSource(sourcePort)) {
                            JOptionPane.showMessageDialog(this, "There are components which need to get events from one of the operators you tried to delete.");
                            return;
                        }
                        if (!(targetPort.getOperator() instanceof HasFloatingNumberOfInPorts) || !this.schedule.getEventController().isEventSource(targetPort)) continue;
                        JOptionPane.showMessageDialog(this, "There are components which need to get events from one of the operators you tried to delete.");
                        return;
                    }
                }
            }
            this.graph.getModel().remove(toRemove.toArray());
        }
        GraphLayoutCache layoutCache = this.graph.getGraphLayoutCache();
        CellView[] allViews = layoutCache.getAllDescendants(layoutCache.getRoots());
        this.graph.getGraphLayoutCache().refresh(allViews, false);
    }

    protected void editParameterControllers(ActionEvent e) {
        ParameterControllerDialog pcDialog = new ParameterControllerDialog((Dialog)this, this.schedule);
        pcDialog.setVisible(true);
    }

    public void valueChanged(GraphSelectionEvent e) {
        boolean enabled = !this.graph.isSelectionEmpty();
        Object[] selected = this.graph.getSelectionCells();
        if (selected.length == 1 && selected[0] instanceof OperatorGraphCell) {
            this.displayObjectInspector(((OperatorGraphCell)selected[0]).getOperator());
        }
        boolean deletableCells = false;
        int i = 0;
        while (i < selected.length) {
            Object object = selected[i];
            if (object instanceof OperatorGraphCell) {
                if (this.graphModel.getOperatorGraph().isOperatorRemovable(((OperatorGraphCell)object).getOperator())) {
                    deletableCells = true;
                    break;
                }
            } else if (object instanceof Edge) {
                deletableCells = true;
                break;
            }
            ++i;
        }
        this.delete.setEnabled(enabled && deletableCells);
    }

    public void displayObjectInspector(Module m) {
        ConfigurationPanel configurationPanel = new ConfigurationPanel(m, this.schedule.getEventController(), this.schedule.getPossibleEventSources(), this.schedule.getBatchList());
        configurationPanel.setPreferredSize(new Dimension(120, 20));
        configurationPanel.setMinimumSize(new Dimension(120, 20));
        this.displayToRight(configurationPanel);
    }

    protected DefaultTreeModel createOperatorTreeModel() {
        DefaultTreeModel modules = this.manager.getTreeModelOfOperators(this.schedule.getGenotypeSearchSpace());
        return modules;
    }

    protected void open(ActionEvent e) {
        Preferences pref = Preferences.userNodeForPackage(EditorDialog.class);
        String graphDirectory = pref.get("GraphDirectory", null);
        JFileChooser c = new JFileChooser();
        if (graphDirectory != null) {
            c.setCurrentDirectory(new File(graphDirectory));
        }
        c.setFileFilter(filter);
        int accepted = c.showOpenDialog(this);
        if (accepted != 0) {
            return;
        }
        File f = c.getSelectedFile();
        try {
            OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(f));
            FreakGraphModel model = ogFile.generateGraph(this.schedule);
            this.graphModel.getOperatorGraph().removeFromEventController();
            this.graph.getModel().removeGraphModelListener(this.graphModelListener);
            this.graphModel = model;
            this.graph.setModel(model);
            this.graph.getModel().addGraphModelListener(this.graphModelListener);
            this.schedule.setGraphModel(model);
            this.graph.stopEditing();
            this.graph.clearSelection();
            GraphLayoutCache layoutCache = this.graph.getGraphLayoutCache();
            CellView[] allViews = layoutCache.getAllDescendants(layoutCache.getRoots());
            this.graph.getGraphLayoutCache().refresh(allViews, false);
            this.lastFile = f;
            pref.put("GraphDirectory", f.getParent());
            this.clearDisplayedConfigurationPanel();
            this.displayObjectInspector(null);
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "Failed: " + exc.toString(), "Error", 0);
            exc.printStackTrace();
            this.newGraph(e);
        }
    }

    private boolean doSave(File f) {
        FreakGraphModel model = (FreakGraphModel)this.graph.getModel();
        try {
            OperatorGraphFile ogFile = new OperatorGraphFile(model);
            ogFile.write(new FileOutputStream(f));
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, "Failed: " + exc.toString(), "Error", 0);
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    protected void save(ActionEvent e) {
        if (this.lastFile == null) {
            this.saveAs(e);
        } else {
            this.doSave(this.lastFile);
        }
    }

    protected void saveAs(ActionEvent e) {
        Preferences pref = Preferences.userNodeForPackage(EditorDialog.class);
        String graphDirectory = pref.get("GraphDirectory", null);
        JFileChooser c = new JFileChooser();
        if (graphDirectory != null) {
            c.setCurrentDirectory(new File(graphDirectory));
        }
        c.setFileFilter(filter);
        int accepted = c.showSaveDialog(this);
        if (accepted != 0) {
            return;
        }
        if (c.getSelectedFile().exists()) {
            Object[] options = new Object[]{"OK", "Cancel"};
            int answer = JOptionPane.showOptionDialog(null, "Replace existing file " + c.getSelectedFile() + "?", "Warning", -1, 2, null, options, options[0]);
            if (answer != 0) {
                return;
            }
        }
        File f = c.getSelectedFile().getAbsoluteFile();
        if (this.doSave(f = filter.fixExtension(f))) {
            this.lastFile = f;
            pref.put("GraphDirectory", f.getParent());
        }
    }

    protected void close(ActionEvent e) {
        block5: {
            try {
                ConfigurationPanel configurationPanel = this.getDisplayedConfigurationPanel();
                if (configurationPanel != null) {
                    configurationPanel.finishEditing();
                }
            }
            catch (InspectorVetoException ex) {
                String message = "The properties of module " + this.getDisplayedConfigurationPanel().getConfiguredModule().getName() + " are invalid.\n" + ex.getMessage();
                JOptionPane.showMessageDialog(this, message, "Invalid Property Settings", 0);
                return;
            }
            try {
                this.graphModel.getOperatorGraph().checkSyntax();
            }
            catch (GraphSyntaxException gse) {
                Object[] options = new String[]{"Close", "Cancel"};
                int result = JOptionPane.showOptionDialog(this, "You won't be able to run the simulation.\nClose anyway?", "Invalid Graph Syntax", 0, 2, null, options, options[1]);
                if (result != 1) break block5;
                return;
            }
        }
        this.graph.getModel().removeGraphModelListener(this.graphModelListener);
        super.close(e);
    }

    protected void newGraph(ActionEvent e) {
        FreakGraphModel model = new FreakGraphModel(this.schedule);
        model.getOperatorGraph().createEvents();
        model.refreshFloatingPorts();
        this.graphModel.getOperatorGraph().removeFromEventController();
        this.graph.getModel().removeGraphModelListener(this.graphModelListener);
        this.graphModel = model;
        this.graph.setModel(model);
        this.graph.getModel().addGraphModelListener(this.graphModelListener);
        this.schedule.setGraphModel(model);
        this.graph.stopEditing();
        this.graph.clearSelection();
        GraphLayoutCache layoutCache = this.graph.getGraphLayoutCache();
        CellView[] allViews = layoutCache.getAllDescendants(layoutCache.getRoots());
        this.graph.getGraphLayoutCache().refresh(allViews, false);
        this.lastFile = null;
        this.clearDisplayedConfigurationPanel();
        this.displayObjectInspector(null);
    }

    private class FreakGraphModelListener
    implements GraphModelListener {
        Schedule schedule;

        public FreakGraphModelListener(Schedule schedule) {
            this.schedule = schedule;
        }

        public void graphChanged(GraphModelEvent e) {
            e.getChange();
            Object[] inserted = e.getChange().getInserted();
            Object[] removed = e.getChange().getRemoved();
            Object[] changed = e.getChange().getChanged();
            if (inserted != null) {
                this.insert(inserted);
            }
            if (removed != null) {
                this.remove(removed);
            }
            if (changed != null) {
                this.change(changed);
            }
        }

        protected void remove(Object[] toRemove) {
            int i = 0;
            while (i < toRemove.length) {
                Object object = toRemove[i];
                if (object instanceof FreakEdge) {
                    FreakEdge edge = (FreakEdge)object;
                    FreakPort source = edge.getSourcePort();
                    FreakPort target = edge.getTargetPort();
                    Port sourcePort = (Port)source.getUserObject();
                    Port targetPort = (Port)target.getUserObject();
                    EditorDialog.this.graphModel.getOperatorGraph().disconnect(sourcePort, targetPort);
                    if (sourcePort.getOperator() instanceof HasFloatingNumberOfOutPorts && sourcePort.getNumberOfPartners() == 0) {
                        ((HasFloatingNumberOfOutPorts)((Object)sourcePort.getOperator())).removeOutPort(sourcePort.getNumber());
                    }
                    if (targetPort.getOperator() instanceof HasFloatingNumberOfInPorts && targetPort.getNumberOfPartners() == 0) {
                        ((HasFloatingNumberOfInPorts)((Object)targetPort.getOperator())).removeInPort(targetPort.getNumber());
                    }
                } else if (object instanceof OperatorGraphCell) {
                    OperatorGraphCell cell = (OperatorGraphCell)object;
                    Operator operator = cell.getOperator();
                    EditorDialog.this.graphModel.getOperatorGraph().removeOperator(operator);
                } else if (!(object instanceof FreakPort)) {
                    throw new RuntimeException("don't know how to remove " + object + " of class " + object.getClass());
                }
                ++i;
            }
        }

        protected void insert(Object[] toInsert) {
            int i = 0;
            while (i < toInsert.length) {
                Object object = toInsert[i];
                if (object instanceof Edge) {
                    Port targetPort;
                    Port sourcePort;
                    block11: {
                        Edge edge = (Edge)object;
                        FreakPort source = (FreakPort)edge.getSource();
                        FreakPort target = (FreakPort)edge.getTarget();
                        sourcePort = source.getPort();
                        targetPort = target.getPort();
                        try {
                            if (sourcePort != null && targetPort != null) {
                                if (sourcePort instanceof OutPort && targetPort instanceof InPort) {
                                    EditorDialog.this.graphModel.getOperatorGraph().connect(sourcePort, targetPort);
                                    break block11;
                                }
                                throw new IllegalArgumentException("source port must be outport and target port must be inport");
                            }
                            throw new IllegalArgumentException("source and target ports must not be null");
                        }
                        catch (PortConnectException e) {
                            e.printStackTrace();
                        }
                    }
                    if (sourcePort.getOperator() instanceof HasFloatingNumberOfOutPorts && sourcePort.getNumberOfPartners() == 1) {
                        ((HasFloatingNumberOfOutPorts)((Object)sourcePort.getOperator())).addOutPort();
                    }
                    if (targetPort.getOperator() instanceof HasFloatingNumberOfInPorts && targetPort.getNumberOfPartners() == 1) {
                        ((HasFloatingNumberOfInPorts)((Object)targetPort.getOperator())).addInPort();
                    }
                } else if (object instanceof OperatorGraphCell) {
                    OperatorGraphCell cell = (OperatorGraphCell)object;
                    Operator operator = cell.getOperator();
                    EditorDialog.this.graphModel.getOperatorGraph().addOperator(operator);
                } else {
                    System.out.println("don't know how to insert " + object + " of class " + object.getClass());
                }
                ++i;
            }
        }

        protected void change(Object[] changed) {
        }
    }
}

