/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.generalstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class IsingModelHypercube
extends AbstractStaticSingleObjectiveFitnessFunction
implements Configurable {
    private int k;
    private int cubeLength;
    private int[] factors;

    public IsingModelHypercube(Schedule schedule) {
        super(schedule);
        this.setPropertyDimension(new Integer(1));
    }

    public void initialize() {
        super.initialize();
        if (this.factors != null && this.factors[this.factors.length - 1] * this.cubeLength != ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension()) {
            this.setPropertyDimension(new Integer(1));
        }
    }

    protected double evaluate(Genotype genotype) {
        double fitness = 0.0;
        int[] gen = ((GeneralStringGenotype)genotype).getIntArray();
        int i = 0;
        while (i < gen.length) {
            int j = 0;
            while (j < this.k) {
                int neighbor2;
                int neighbor1 = this.getIndexOfNeighbor(i, j, 1);
                if (neighbor1 > i && gen[i] == gen[neighbor1]) {
                    fitness += 1.0;
                }
                if (this.cubeLength > 2 && (neighbor2 = this.getIndexOfNeighbor(i, j, -1)) > i && gen[i] == gen[neighbor2]) {
                    fitness += 1.0;
                }
                ++j;
            }
            ++i;
        }
        return fitness;
    }

    private int getIndexOfNeighbor(int node, int d, int offset) {
        int dValueOfNode = node % (this.factors[d] * this.cubeLength) / this.factors[d];
        int indexWithdZero = node - dValueOfNode * this.factors[d];
        int neighborsdValue = (dValueOfNode + offset + this.cubeLength) % this.cubeLength;
        return indexWithdZero + neighborsdValue * this.factors[d];
    }

    public String getName() {
        return "Ising Model (Hypercube)";
    }

    public String getDescription() {
        return "The Ising Model is a model derived from statistical mechanics describing the behavior of atoms with two spins where neighbored atoms tend to orient in the same direction as their neighbors.\nAnother view is an inversion of the colorability problem: an edge contributes a value of 1 to the fitness if and only if its nodes have got the same color. So, all colorings with only one color are optimal.\nHere, the graph is described by a hypercube.";
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        int dim = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
        return this.cubeLength == 2 ? dim * this.k / 2 : dim * this.k;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public void setPropertyDimension(Integer i) {
        if (i > 0) {
            int dim = ((GeneralString)this.getSchedule().getGenotypeSearchSpace()).getDimension();
            int newCubeLength = (int)Math.round(Math.pow(dim, 1.0 / i.doubleValue()));
            int[] newFactors = new int[i.intValue()];
            newFactors[0] = 1;
            int j = 1;
            while (j < i) {
                newFactors[j] = newFactors[j - 1] * newCubeLength;
                ++j;
            }
            if (newFactors[newFactors.length - 1] * newCubeLength == dim) {
                this.k = i;
                this.factors = newFactors;
                this.cubeLength = newCubeLength;
            }
        }
    }

    public Integer getPropertyDimension() {
        return new Integer(this.k);
    }

    public String getShortDescriptionForDimension() {
        return "Hypercube dimension";
    }

    public String getLongDescriptionForDimension() {
        return "The dimension of the hypercube. The length of all sides of the hypercube is the dimension-th root of the genotype's length. Since the length must be an integer, the genotype's length must be of value a^dimension for some a.";
    }
}

