/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.conf.Configuration;

public interface FSConstants {
    public static final int MIN_BLOCKS_FOR_WRITE = 5;
    public static final int BLOCK_INVALIDATE_CHUNK = 1000;
    public static final long QUOTA_DONT_SET = Long.MAX_VALUE;
    public static final long QUOTA_RESET = -1L;
    public static final long HEARTBEAT_INTERVAL = 3L;
    public static final long BLOCKREPORT_INTERVAL = 3600000L;
    public static final long BLOCKREPORT_INITIAL_DELAY = 0L;
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;
    public static final long LEASE_HARDLIMIT_PERIOD = 3600000L;
    public static final long LEASE_RECOVER_PERIOD = 10000L;
    public static final int MAX_PATH_LENGTH = 8000;
    public static final int MAX_PATH_DEPTH = 1000;
    public static final int BUFFER_SIZE = new Configuration().getInt("io.file.buffer.size", 4096);
    public static final int SMALL_BUFFER_SIZE = Math.min(BUFFER_SIZE / 2, 512);
    public static final long DEFAULT_BLOCK_SIZE = 0x4000000L;
    public static final int DEFAULT_DATA_SOCKET_SIZE = 131072;
    public static final int SIZE_OF_INTEGER = 4;
    public static final String HDFS_URI_SCHEME = "hdfs";
    public static final int LAYOUT_VERSION = -19;

    public static enum UpgradeAction {
        GET_STATUS,
        DETAILED_STATUS,
        FORCE_PROCEED;

    }

    public static enum DatanodeReportType {
        ALL,
        LIVE,
        DEAD;

    }

    public static enum SafeModeAction {
        SAFEMODE_LEAVE,
        SAFEMODE_ENTER,
        SAFEMODE_GET;

    }
}

