/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.event;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.event.OntEventHandler;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OntEventsVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OntEventManager
extends StatementListener {
    private static Object[][] s_rdfTypeInit = new Object[][]{{OntEventsVocab.classDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.CLASS();
        }
    }}, {OntEventsVocab.datarangeDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.DATARANGE();
        }
    }}, {OntEventsVocab.propertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.PROPERTY();
        }
    }}, {OntEventsVocab.objectPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.OBJECT_PROPERTY();
        }
    }}, {OntEventsVocab.datatypePropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.DATATYPE_PROPERTY();
        }
    }}, {OntEventsVocab.transitivePropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.TRANSITIVE_PROPERTY();
        }
    }}, {OntEventsVocab.symmetricPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.SYMMETRIC_PROPERTY();
        }
    }}, {OntEventsVocab.functionalPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.FUNCTIONAL_PROPERTY();
        }
    }}, {OntEventsVocab.inverseFunctionalPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.INVERSE_FUNCTIONAL_PROPERTY();
        }
    }}, {OntEventsVocab.annotationPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ANNOTATION_PROPERTY();
        }
    }}, {OntEventsVocab.ontologyPropertyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ONTOLOGY_PROPERTY();
        }
    }}, {OntEventsVocab.restrictionDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.RESTRICTION();
        }
    }}, {OntEventsVocab.allDifferentDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ALL_DIFFERENT();
        }
    }}, {OntEventsVocab.ontologyDeclaration, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ONTOLOGY();
        }
    }}};
    private static Object[][] s_predicateInit = new Object[][]{{OntEventsVocab.intersectionOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.INTERSECTION_OF();
        }
    }}, {OntEventsVocab.equivalentClass, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.EQUIVALENT_CLASS();
        }
    }}, {OntEventsVocab.disjointWith, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.DISJOINT_WITH();
        }
    }}, {OntEventsVocab.equivalentProperty, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.EQUIVALENT_PROPERTY();
        }
    }}, {OntEventsVocab.sameAs, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.SAME_AS();
        }
    }}, {OntEventsVocab.differentFrom, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.DIFFERENT_FROM();
        }
    }}, {OntEventsVocab.distinctMembers, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.DISTINCT_MEMBERS();
        }
    }}, {OntEventsVocab.unionOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.UNION_OF();
        }
    }}, {OntEventsVocab.intersectionOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.INTERSECTION_OF();
        }
    }}, {OntEventsVocab.complementOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.COMPLEMENT_OF();
        }
    }}, {OntEventsVocab.oneOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ONE_OF();
        }
    }}, {OntEventsVocab.onProperty, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ON_PROPERTY();
        }
    }}, {OntEventsVocab.allValuesFrom, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.ALL_VALUES_FROM();
        }
    }}, {OntEventsVocab.hasValue, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.HAS_VALUE();
        }
    }}, {OntEventsVocab.someValuesFrom, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.SOME_VALUES_FROM();
        }
    }}, {OntEventsVocab.minCardinality, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.MIN_CARDINALITY();
        }
    }}, {OntEventsVocab.maxCardinality, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.MAX_CARDINALITY();
        }
    }}, {OntEventsVocab.cardinalityQ, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.CARDINALITY_Q();
        }
    }}, {OntEventsVocab.minCardinalityQ, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.MIN_CARDINALITY_Q();
        }
    }}, {OntEventsVocab.maxCardinalityQ, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.MAX_CARDINALITY_Q();
        }
    }}, {OntEventsVocab.cardinality, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.CARDINALITY();
        }
    }}, {OntEventsVocab.inverseOf, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.INVERSE_OF();
        }
    }}, {OntEventsVocab.imports, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.IMPORTS();
        }
    }}, {OntEventsVocab.versionInfo, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.VERSION_INFO();
        }
    }}, {OntEventsVocab.priorVersion, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.PRIOR_VERSION();
        }
    }}, {OntEventsVocab.backwardCompatibleWith, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.BACKWARD_COMPATIBLE_WITH();
        }
    }}, {OntEventsVocab.incompatibleWith, new ProfileAccessor(){

        public Resource get(Profile p) {
            return p.INCOMPATIBLE_WITH();
        }
    }}};
    private Map m_handlers = new HashMap();
    private Map m_rdfTypeToEventType = new HashMap();
    private Map m_predicateToEventType = new HashMap();
    private OntEventHandler m_defaultHandler = null;

    public OntEventManager(OntModel m) {
        Profile p = m.getProfile();
        this.initialiseTable(this.m_rdfTypeToEventType, p, s_rdfTypeInit);
        this.initialiseTable(this.m_predicateToEventType, p, s_predicateInit);
    }

    public void addedStatement(Statement s) {
        this.processStatement(s, true);
    }

    public void removedStatement(Statement s) {
        this.processStatement(s, false);
    }

    public void raise(Resource event, boolean added, Model source, RDFNode arg0, RDFNode arg1, RDFNode arg2) {
        OntEventHandler h = this.getHandler(event);
        if (h != null) {
            h.action(event, added, source, arg0, arg1, arg2);
        } else if (this.m_defaultHandler != null) {
            this.m_defaultHandler.action(event, added, source, arg0, arg1, arg2);
        }
    }

    public void addDefaultHandler(OntEventHandler handler) {
        this.m_defaultHandler = handler;
    }

    public void addHandler(Resource event, OntEventHandler handler) {
        this.m_handlers.put(event, handler);
    }

    public void addHandlers(Object[][] handlers) {
        int i = 0;
        while (i < handlers.length) {
            Resource r = (Resource)handlers[i][0];
            OntEventHandler h = (OntEventHandler)handlers[i][1];
            this.addHandler(r, h);
        }
    }

    public OntEventHandler getHandler(Resource event) {
        return (OntEventHandler)this.m_handlers.get(event);
    }

    public OntEventHandler getDefaultHandler() {
        return this.m_defaultHandler;
    }

    public void removeHandler(Resource event) {
        this.m_handlers.remove(event);
    }

    public boolean hasHandler(Resource event) {
        return this.m_handlers.containsKey(event);
    }

    public Iterator listRegisteredEvents() {
        return this.m_handlers.keySet().iterator();
    }

    private void initialiseTable(Map map, Profile p, Object[][] source) {
        for (int i = 0; i < source.length; ++i) {
            Resource evType = (Resource)source[i][0];
            Resource key = ((ProfileAccessor)source[i][1]).get(p);
            if (key == null) continue;
            map.put(key, evType);
        }
    }

    private void processStatement(Statement s, boolean added) {
        if (s.getPredicate().equals(RDF.type)) {
            Resource type = s.getResource();
            Resource evType = (Resource)this.m_rdfTypeToEventType.get(type);
            if (evType != null) {
                this.raise(evType, added, s.getModel(), s.getSubject(), null, null);
            } else {
                this.raise(OntEventsVocab.individualDeclaration, added, s.getModel(), s.getSubject(), type, null);
            }
        } else {
            Property pred = s.getPredicate();
            Resource evType = (Resource)this.m_predicateToEventType.get(pred);
            if (evType != null) {
                this.raise(evType, added, s.getModel(), s.getSubject(), s.getObject(), null);
            } else {
                this.raise(OntEventsVocab.userData, added, s.getModel(), s.getSubject(), pred, s.getObject());
            }
        }
    }

    private static interface ProfileAccessor {
        public Resource get(Profile var1);
    }
}

