% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMark-package.R
\name{Burnham}
\alias{Burnham}
\title{#' Burnham Live-Dead Model}
\description{
An example of the Burnham live-dead model using simulated data LD1.inp from Chapter 9 of Cooch and White
}
\examples{
\donttest{
###############################################################################
#### RMARK script for conducting the Burnham model tutorial in Chapter 9.3 ####
#################### the of the Cooch and White MARK book #####################
###############################################################################
##################### Code by: Luke Eberhart-Phillips #########################
###### Dept. Animal Behaviour, Bielefeld University, Bielefeld, Germany #######
##################### email: luke.eberhart at gmail.com ##########################
###############################################################################

# import/convert the simulated "LD1.inp" MARK capture history into an RMARK 
# dataframe, while defining the two groups as "Y" for individuals marked as 
# young, and "A" for individuals marked as adults
# NOTE: the "LD1.inp" file is found in the zipped folder downloaded when you
# click on "Example data files" in the drop-down menu of the MARK book webpage
# (http://www.phidot.org/software/mark/docs/book/)
pathtodata=paste(path.package("RMark"),"extdata",sep="/")
LD=convert.inp(paste(pathtodata,"ld1",sep="/"),
           group.df=data.frame(age_marked=c("Y","A")))
# process the data by defining the model type as "Burnham" and the groups in
# the data.  In this case the only group is the age at which individuals were 
# marked
LD.proc=process.data(data = LD, 
	model = "Burnham",
	groups=c("age_marked"),
	age.var=1,
	initial.age=c(1,0))

# make the design data from the process data above
LD.ddl=make.design.data(LD.proc)

# add the correct binning to the design data so that individuals that were
# marked as young are adults in their second year of life, where as those
# marked as adults are adults for their entire life.
LD.ddl=add.design.data(data = LD.proc,
	ddl = LD.ddl,
	parameter="S", 
	type = "age",
	bins = c(0,1,8),
	right = FALSE,
	name = "age",
	replace = TRUE)

# do the same to the F parameter
LD.ddl=add.design.data(data = LD.proc,
	ddl = LD.ddl,
	parameter="F", 
	type = "age",
	bins = c(0,1,8),
	right = FALSE,
	name = "age",
	replace = TRUE)

# check parameter matrix to see if groups were binned correctly in the S matrix
PIMS(mark(data = LD.proc,
			ddl = LD.ddl,
			model.parameters=list(S=list(formula=~age)),
			output=FALSE,
			model = "Burnham"),
	"S")

# Create the formulas that describe variation in the parameter we want to test.
# In this case we want to test for an age effect on survival and fidelity,
# while keeping recapture and recovery probabilities constant.
S.age=list(formula=~age) # S(age)
p.dot=list(formula=~1) # p(.)
F.age=list(formula=~age) # F(age)
r.dot=list(formula=~1) # r(.)

# Run the model
LD.model.age.F.S=mark(data = LD.proc,
	ddl = LD.ddl, 
	model.parameters = list(S = S.age, p = p.dot, 
			F =F.age, r = r.dot), 
	invisible = FALSE, 
	model = "Burnham")

# Check the paramter estimates, they should be the same as those generated
# when doing the tutorial in chapter 9.3 of the in MARK Book (table on pg 9-8)
LD.model.age.F.S$results$real

# Clean your working directory
cleanup(ask=FALSE)
}
}
\author{
Luke Eberhart-Phillips<luke.eberhart at gmail.com>
}

