/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceOutput {
    final BasicDBObject _raw;
    final String _collname;
    String _dbname = null;
    final Iterable<DBObject> _resultSet;
    final DBCollection _coll;
    final BasicDBObject _counts;
    final DBObject _cmd;

    MapReduceOutput(DBCollection from2, DBObject cmd, BasicDBObject raw) {
        this._raw = raw;
        this._cmd = cmd;
        if (raw.containsField("results")) {
            this._coll = null;
            this._collname = null;
            this._resultSet = (Iterable)raw.get("results");
        } else {
            Object res = raw.get("result");
            if (res instanceof String) {
                this._collname = (String)res;
            } else {
                BasicDBObject output = (BasicDBObject)res;
                this._collname = output.getString("collection");
                this._dbname = output.getString("db");
            }
            DB db = from2._db;
            if (this._dbname != null) {
                db = db.getSisterDB(this._dbname);
            }
            this._coll = db.getCollection(this._collname);
            this._resultSet = this._coll.find();
        }
        this._counts = (BasicDBObject)raw.get("counts");
    }

    public Iterable<DBObject> results() {
        return this._resultSet;
    }

    public void drop() {
        if (this._coll != null) {
            this._coll.drop();
        }
    }

    public DBCollection getOutputCollection() {
        return this._coll;
    }

    public BasicDBObject getRaw() {
        return this._raw;
    }

    public DBObject getCommand() {
        return this._cmd;
    }

    public String toString() {
        return this._raw.toString();
    }
}

