% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_meta.R
\name{add_meta}
\alias{add_meta}
\title{Add metadata to a nexml file}
\usage{
add_meta(meta, nexml = new("nexml"), level = c("nexml", "otus", "trees",
  "characters"), namespaces = NULL, i = 1, at_id = NULL)
}
\arguments{
\item{meta}{a meta S4 object, e.g. ouput of the function \code{\link{meta}}, or a list of these meta objects}

\item{nexml}{(S4) object}

\item{level}{the level at which the metadata annotation should be added.}

\item{namespaces}{named character string for any additional namespaces that should be defined.}

\item{i}{for otus, trees, characters: if there are multiple such blocks, which one should be annotated?  Default is first/only block.}

\item{at_id}{the id of the element to be annotated.  Optional, advanced use only.}
}
\value{
the updated nexml object
}
\description{
Add metadata to a nexml file
}
\examples{
## Create a new nexml object with a single metadata element: 
modified <- meta(property = "prism:modificationDate", content = "2013-10-04")
nex <- add_meta(modified) # Note: 'prism' is defined in nexml_namespaces by default.  

## Write multiple metadata elements, including a new namespace:  
website <- meta(href = "http://carlboettiger.info", 
                rel = "foaf:homepage")              # meta can be link-style metadata
nex <- add_meta(list(modified,  website), 
                namespaces = c(foaf = "http://xmlns.com/foaf/0.1/"))

## Append more metadata, and specify a level: 
history <- meta(property = "skos:historyNote",
                 content = "Mapped from the bird.orders data in the ape package using RNeXML")
nex <- add_meta(history, 
                nexml = nex,
                level = "trees",
                namespaces = c(skos = "http://www.w3.org/2004/02/skos/core#"))

}
\seealso{
\code{\link{meta}} \code{\link{add_trees}} \code{\link{add_characters}} \code{\link{add_basic_meta}}
}

