% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createRel.R
\name{createRel}
\alias{createRel}
\title{Relationships}
\usage{
createRel(.fromNode, .relType, .toNode, ...)
}
\arguments{
\item{.fromNode}{A node object.}

\item{.relType}{A character string.}

\item{.toNode}{A node object.}

\item{...}{A named list. Relationship properties in the form key = value.}
}
\value{
A relationship object.
}
\description{
Create a relationship between two nodes with the given type and properties.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice")
bob = createNode(graph, "Person", name = "Bob")
charles = createNode(graph, "Person", name = "Charles")

createRel(alice, "WORKS_WITH", bob)
createRel(bob, "KNOWS", charles, since = 2000, through = "Work")

props = list(since = 2001, through = "School")
createRel(alice, "KNOWS", charles, props)
}
}

