% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{document_network_plot}
\alias{document_network_plot}
\title{Visualize (a subcomponent) of the document similarity network}
\usage{
document_network_plot(g, date_attribute = "date",
  source_attribute = "source", subcomp_i = NULL, dtm = NULL,
  sources = NULL, only_outer_date = FALSE,
  date_format = "\%Y-\%m-\%d \%H:\%M", margins = c(5, 8, 1, 13),
  isolate_color = NULL, source_loops = TRUE, ...)
}
\arguments{
\item{g}{A document similarity network, as created with \link[RNewsflow]{newsflow.compare} or \link[RNewsflow]{document.network}}

\item{date_attribute}{The label of the vertex/document date attribute. Default is "date"}

\item{source_attribute}{The label of the vertex/document source attribute. Default is "source"}

\item{subcomp_i}{Optional. If an integer is given, the network is decomposed into subcomponents (i.e. unconnected components) and only the i-th component is visualized.}

\item{dtm}{Optional. If a document-term matrix that contains the documents in g is given, a wordcloud with the most common words of the network is added.}

\item{sources}{Optional. Use a character vector to select only certain sources}

\item{only_outer_date}{If TRUE, only the labels for the first and last date are reported on the x-axis}

\item{date_format}{The date format of the date labels (see \link[base]{format.POSIXct})}

\item{margins}{The margins of the network plot. The four values represent bottom, left, top and right margin.}

\item{isolate_color}{Optional. Set a custom color for isolates}

\item{source_loops}{If set to FALSE, all edges between vertices/documents of the same source are ignored.}

\item{...}{Additional arguments for the network plotting function \link[igraph]{plot.igraph}}
}
\value{
Nothing.
}
\description{
Visualize (a subcomponent) of the document similarity network
}
\examples{
docnet = docnet
dtm = rnewsflow_dfm

docnet_comps = igraph::decompose.graph(docnet) # get subcomponents

# subcomponent 1
document_network_plot(docnet_comps[[1]]) 

# subcomponent 2 with wordcloud
document_network_plot(docnet_comps[[2]], dtm=dtm) 

# subcomponent 3 with additional arguments passed to plot.igraph 
document_network_plot(docnet_comps[[3]], dtm=dtm, vertex.color='red') 
}
