% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{F_constraint}
\alias{F_constraint}
\alias{as.F_constraint}
\alias{as.F_constraint.NULL}
\alias{as.F_constraint.constraint}
\alias{is.F_constraint}
\alias{terms.F_constraint}
\alias{variable.names.F_constraint}
\title{Function Constraints}
\usage{
F_constraint(F, dir, rhs, J = NULL, names = NULL)

\method{variable.names}{F_constraint}(object, ...)

is.F_constraint(x)

\method{terms}{F_constraint}(x, ...)

as.F_constraint(x, ...)

\method{as.F_constraint}{NULL}(x, ...)

\method{as.F_constraint}{constraint}(x, ...)
}
\arguments{
\item{F}{a \code{function} or a list of \code{function}s of length
\eqn{m}. Each \code{function} takes \eqn{n} parameters as input
and must return a scalar. Thus, \eqn{n} is the number of objective
variables and \eqn{m} is the number of constraints.}

\item{dir}{a character vector with the directions of the
constraints. Each element must be one of \code{"<="}, \code{">="} or \code{"=="}.}

\item{rhs}{a numeric vector with the right hand side of the constraints.}

\item{J}{an optional \code{function} holding the Jacobian of F.}

\item{names}{an optional character vector giving the names of x.}

\item{object}{an R object.}

\item{x}{object to be tested.}

\item{\ldots}{further arguments passed to or from other methods (currently ignored).}
}
\value{
an object of class \code{"F_constraint"} which inherits
from \code{"constraint"}.
}
\description{
Function (or generally speaking nonlinear) constraints are
typically of the form \deqn{f(x) \leq b} where \eqn{f()} is a
well-defined R function taking the objective variables \eqn{x}
(typically a numeric vector) as arguments. \eqn{b} is called the
right hand side of the constraints.
}
\author{
Stefan Theussl
}

