% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.insolation}
\alias{rsaga.insolation}
\title{Incoming Solar Radiation (Insolation)}
\usage{
rsaga.insolation(in.dem, in.vapour, in.latitude, in.longitude, out.direct,
  out.diffuse, out.total, horizontal = FALSE, solconst = 8.164,
  atmosphere = 12000, water.vapour.pressure = 10, type = c("moment",
  "day", "range.of.days", "same.moment.range.of.days"), time.step = 1,
  day.step = 5, days, moment, latitude, bending = FALSE,
  radius = 6366737.96, lat.offset = "user", lat.ref.user = 0,
  lon.offset = "center", lon.ref.user = 0, ...)
}
\arguments{
\item{in.dem}{Name of input digital elevation model (DEM) grid in SAGA grid format (default extension: \code{.sgrd})}

\item{in.vapour}{Optional input: SAGA grid file giving the water vapour pressure in mbar}

\item{in.latitude}{Optional input: SAGA grid file giving for each pixel the latitude in degree}

\item{in.longitude}{Optional input: SAGA grid file giving for each pixel the longitude in degree}

\item{out.direct}{Optional output grid file for direct insolation}

\item{out.diffuse}{Optional output grid file for diffuse insolation}

\item{out.total}{Optional output grid file for total insolation, i.e. the sum of direct and diffuse insolation}

\item{horizontal}{logical; project radiation onto a horizontal surface? (default: \code{FALSE}, i.e. use the actual inclined surface as a reference area)}

\item{solconst}{solar constant in Joule; default: 8.164 J/cm2/min (=1360.7 kWh/m2; the more commonly used solar constant of 1367 kWh/m2 corresponds to 8.202 J/cm2/min)}

\item{atmosphere}{height of atmosphere in m; default: 12000m}

\item{water.vapour.pressure}{if no water vapour grid is given, this argument specifies a constant water vapour pressure that is uniform in space; in mbar, default 10 mbar}

\item{type}{type of time period: \code{"moment"} (equivalent: \code{0}) for a single instant, \code{"day"} (or \code{1}) for a single day, \code{"range.of.days"} (or \code{2}), or \code{"same.moment.range.of.days"} (or \code{3}) for the same moment in a range of days; default: \code{"moment"}}

\item{time.step}{time resolution in hours for discretization within a day}

\item{day.step}{time resolution in days for a range of days}

\item{days}{numeric vector of length 2, specifying the first and last day of a range of days (for \code{type}s 2 and 3)}

\item{moment}{if \code{type="moment"} or \code{"same.moment.range.of.days"}, \code{moment} specifies the time of the day (hour between 0 and 24) for which the insolation is to be calculated}

\item{latitude}{if no \code{in.latitude} grid is given, this will specify a fixed geographical latitude for the entire grid}

\item{bending}{should planetary bending be modeled? (default: \code{FALSE})}

\item{radius}{planetary radius}

\item{lat.offset}{\code{latitude} relates to grids \code{"bottom"}(equivalent code: \code{0}), \code{"center"} (1), \code{"top"} (2), or \code{"user"}-defined reference (default: \code{"user"}); in the latter case, \code{lat.ref.user} defines the reference}

\item{lat.ref.user}{if \code{in.latitude} is missing and \code{lat.offset="user"}, then this numeric value defines the latitudinal reference (details??)}

\item{lon.offset}{local time refers to grid's \code{"left"} edge (code 0), \code{"center"} (1), \code{"right"} edge (2), or a  \code{"user"}-defined reference.}

\item{lon.ref.user}{if \code{in.longitude} is missing and \code{lon.offset="user"}, then this numeric value defines the reference of the local time (details??)}

\item{...}{optional arguments to be passed to \code{\link{rsaga.geoprocessor}}, including the \code{env} RSAGA geoprocessing environment}
}
\value{
The type of object returned depends on the \code{intern} argument passed to the \code{\link{rsaga.geoprocessor}}. For \code{intern=FALSE} it is a numerical error code (0: success), or otherwise (default) a character vector with the module's console output.
}
\description{
This function calculates the amount of incoming solar radiation (insolation) depending on slope, aspect, and atmospheric properties. Module not available in SAGA GIS 2.0.6 and 2.0.7.
}
\details{
Calculation of incoming solar radiation (insolation). Based on the SADO (System for the Analysis of Discrete Surfaces) routines developed  by Boehner & Trachinow.
}
\note{
This function uses module \code{Insolation} (code: 3) from SAGA library \code{ta_lighting}. It is availble in SAGA GIS 2.0.4 and 2.0.5 but not 2.0.6 and 2.0.7; see \code{\link{rsaga.pisr}}.
}
\author{
Alexander Brenning (R interface), Olaf Conrad (SAGA module)
}
\seealso{
\code{\link{rsaga.solar.radiation}}, \code{\link{rsaga.pisr}},  \code{\link{rsaga.hillshade}}
}
\keyword{interface}
\keyword{spatial}

