% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-core.R
\name{rsaga.set.env}
\alias{rsaga.set.env}
\title{Internal function that sets the RSAGA Geoprocessing Evironment manually}
\usage{
rsaga.set.env(
  workspace = NULL,
  cmd = NULL,
  path = NULL,
  modules = NULL,
  version = NA,
  cores = NULL,
  parallel = NULL
)
}
\arguments{
\item{workspace}{path of the working directory for SAGA; defaults to the current directory (\code{"."}).}

\item{cmd}{name of the SAGA command line program; defaults to \code{saga_cmd.exe}, its name under Windows}

\item{path}{path in which to find \code{cmd}; \code{rsaga.env} is usually able to find SAGA on your system if it is installed; see Details.}

\item{modules}{path in which to find SAGA libraries; see Details}

\item{version}{optional character string: SAGA GIS (API) version, e.g. \code{"2.0.8"}; if missing, a call to \code{\link[=rsaga.get.version]{rsaga.get.version()}} is used to determine version number of SAGA API}

\item{cores}{optional numeric argument, or \code{NA}: number of cores used by SAGA GIS; supported only by SAGA GIS 2.1.0 (and higher), ignored otherwise (with a warning). Multicore-enabled SAGA GIS modules such as the one used by \code{\link[=rsaga.pisr]{rsaga.pisr()}} seem to run in multicore mode by default when this argument is not specified, therefore \code{cores} should only be specified to use a smaller number of cores than available on a machine.}

\item{parallel}{optional logical argument (default: \code{FALSE}): if \code{TRUE}, run RSAGA functions that are capable of parallel processing in parallel mode; note that this is completely independent of the behaviour of SAGA GIS (which can be controlled using the \code{cores} argument); currently only some RSAGA functions support parallel processing (e.g., \code{\link[=pick.from.ascii.grid]{pick.from.ascii.grid()}} or \code{\link[=rsaga.get.modules]{rsaga.get.modules()}}). \code{parallel=TRUE} requires that a parallel backend such as \pkg{doSNOW} or \pkg{doMC} is available and has been started prior to calling any parallelized RSAGA function, otherwise warnings may be generated}
}
\description{
Internal function that sets the RSAGA Geoprocessing Evironment manually
}
