% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.R
\docType{methods}
\name{SQLite}
\alias{SQLite}
\alias{RSQLite}
\alias{RSQLite-package}
\alias{dbConnect,SQLiteDriver-method}
\alias{SQLITE_RWC}
\alias{SQLITE_RW}
\alias{SQLITE_RO}
\alias{dbConnect,SQLiteConnection-method}
\alias{dbDisconnect,SQLiteConnection-method}
\title{Connect to an SQLite database}
\usage{
SQLite(...)

\S4method{dbConnect}{SQLiteDriver}(drv, dbname = "", ...,
  loadable.extensions = TRUE, default.extensions = loadable.extensions,
  cache_size = NULL, synchronous = "off", flags = SQLITE_RWC,
  vfs = NULL, bigint = c("integer64", "integer", "numeric", "character"))

\S4method{dbConnect}{SQLiteConnection}(drv, ...)

\S4method{dbDisconnect}{SQLiteConnection}(conn, ...)
}
\arguments{
\item{...}{In previous versions, \code{SQLite()} took arguments. These
have now all been moved to \code{\link[=dbConnect]{dbConnect()}}, and any arguments here
will be ignored with a warning.}

\item{drv, conn}{An objected generated by \code{\link[=SQLite]{SQLite()}}, or an existing
\code{\linkS4class{SQLiteConnection}}. If an connection, the connection
will be cloned.}

\item{dbname}{The path to the database file. SQLite keeps each database
instance in one single file. The name of the database \emph{is} the file
name, thus database names should be legal file names in the running
platform. There are two exceptions:

\itemize{
\item \code{""} will create a temporary on-disk database. The file
will be deleted when the connection is closed.
\item \code{":memory:"} or \code{"file::memory:"} will create a temporary
in-memory database.
}}

\item{loadable.extensions}{When \code{TRUE} (default) SQLite3
loadable extensions are enabled. Setting this value to \code{FALSE}
prevents extensions from being loaded.}

\item{default.extensions}{When \code{TRUE} (default) the \code{\link[=initExtension]{initExtension()}}
function will be called on the new connection.Setting this value to \code{FALSE}
requires calling \code{initExtension()} manually.}

\item{cache_size}{Advanced option. A positive integer to change the maximum
number of disk pages that SQLite holds in memory (SQLite's default is
2000 pages). See \url{http://www.sqlite.org/pragma.html#pragma_cache_size}
for details.}

\item{synchronous}{Advanced options. Possible values for \code{synchronous}
are "off" (the default), "normal", or  "full".  Users have reported
significant speed ups using \code{sychronous = "off"}, and the SQLite
documentation itself implies considerable improved performance at the very
modest risk of database corruption in the unlikely case of the operating
system (\emph{not} the R application) crashing. See
\url{http://www.sqlite.org/pragma.html#pragma_synchronous} for details.}

\item{flags}{\code{SQLITE_RWC}: open the database in read/write mode
and create the database file if it does not already exist;
\code{SQLITE_RW}: open the database in read/write mode. Raise an error
if the file does not already exist; \code{SQLITE_RO}: open the database in
read only mode.  Raise an error if the file does not already exist}

\item{vfs}{Select the SQLite3 OS interface. See
\url{http://www.sqlite.org/vfs.html} for details. Allowed values are
\code{"unix-posix"}, \code{"unix-unix-afp"},
\code{"unix-unix-flock"}, \code{"unix-dotfile"}, and
\code{"unix-none"}.}

\item{bigint}{The R type that 64-bit integer types should be mapped to,
default is \link[bit64:integer64]{bit64::integer64}, which allows the full range of 64 bit
integers.}
}
\value{
\code{SQLite()} returns an object of class \linkS4class{SQLiteDriver}.

\code{dbConnect()} returns an object of class \linkS4class{SQLiteConnection}.
}
\description{
Together, \code{SQLite()} and \code{dbConnect()} allow you to connect to
a SQLite database file. See \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}} for how to issue queries
and receive results.
}
\details{
Connections are automatically cleaned-up after they're deleted and
reclaimed by the GC. You can use \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}} to terminate the
connection early, but it will not actually close until all open result
sets have been closed (and you'll get a warning message to this effect).
}
\examples{
library(DBI)
# Initialize a temporary in memory database and copy a data.frame into it
con <- dbConnect(RSQLite::SQLite(), ":memory:")
data(USArrests)
dbWriteTable(con, "USArrests", USArrests)
dbListTables(con)

# Fetch all query results into a data frame:
dbGetQuery(con, "SELECT * FROM USArrests")

# Or do it in batches
rs <- dbSendQuery(con, "SELECT * FROM USArrests")
d1 <- dbFetch(rs, n = 10)      # extract data in chunks of 10 rows
dbHasCompleted(rs)
d2 <- dbFetch(rs, n = -1)      # extract all remaining data
dbHasCompleted(rs)
dbClearResult(rs)

# clean up
dbDisconnect(con)
}
\seealso{
The corresponding generic functions \code{\link[DBI:dbConnect]{DBI::dbConnect()}} and \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}}.
}
