/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.ArrayList;
import java.util.Collections;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.GraftSplit;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48.Stats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class C45PruneableClassifierTreeG
extends ClassifierTree {
    static final long serialVersionUID = 66981207374331964L;
    boolean m_pruneTheTree = false;
    float m_CF = 0.25f;
    boolean m_subtreeRaising = true;
    boolean m_cleanup = true;
    boolean m_relabel = false;
    double m_BiProbCrit = 1.64;
    boolean m_Debug = false;

    public C45PruneableClassifierTreeG(ModelSelection modelSelection, boolean bl, float f, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        super(modelSelection);
        this.m_pruneTheTree = bl;
        this.m_CF = f;
        this.m_subtreeRaising = bl2;
        this.m_cleanup = bl4;
        this.m_relabel = bl3;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public C45PruneableClassifierTreeG(ModelSelection modelSelection, Instances instances, ClassifierSplitModel classifierSplitModel, boolean bl, float f, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(modelSelection);
        this.m_relabel = bl4;
        this.m_cleanup = bl5;
        this.m_localModel = classifierSplitModel;
        this.m_train = instances;
        this.m_test = null;
        this.m_isLeaf = bl3;
        this.m_isEmpty = !(classifierSplitModel.distribution().total() > 0.0);
        this.m_pruneTheTree = bl;
        this.m_CF = f;
        this.m_subtreeRaising = bl2;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.buildTree(instances, this.m_subtreeRaising);
        this.collapse();
        if (this.m_pruneTheTree) {
            this.prune();
        }
        this.doGrafting(instances);
        if (this.m_cleanup) {
            this.cleanup(new Instances(instances, 0));
        }
    }

    public final void collapse() {
        if (!this.m_isLeaf) {
            double d;
            double d2 = this.getTrainingErrors();
            if (d2 >= (d = this.localModel().distribution().numIncorrect()) - 0.001) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
            } else {
                for (int i = 0; i < this.m_sons.length; ++i) {
                    this.son(i).collapse();
                }
            }
        }
    }

    public void prune() throws Exception {
        if (!this.m_isLeaf) {
            double d;
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.son(i).prune();
            }
            int n = this.localModel().distribution().maxBag();
            double d2 = this.m_subtreeRaising ? this.son(n).getEstimatedErrorsForBranch(this.m_train) : Double.MAX_VALUE;
            double d3 = this.getEstimatedErrorsForDistribution(this.localModel().distribution());
            if (Utils.smOrEq(d3, (d = this.getEstimatedErrors()) + 0.1) && Utils.smOrEq(d3, d2 + 0.1)) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
                return;
            }
            if (Utils.smOrEq(d2, d + 0.1)) {
                C45PruneableClassifierTreeG c45PruneableClassifierTreeG = this.son(n);
                this.m_sons = c45PruneableClassifierTreeG.m_sons;
                this.m_localModel = c45PruneableClassifierTreeG.localModel();
                this.m_isLeaf = c45PruneableClassifierTreeG.m_isLeaf;
                this.newDistribution(this.m_train);
                this.prune();
            }
        }
    }

    protected ClassifierTree getNewTree(Instances instances) throws Exception {
        C45PruneableClassifierTreeG c45PruneableClassifierTreeG = new C45PruneableClassifierTreeG(this.m_toSelectModel, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, this.m_relabel, this.m_cleanup);
        c45PruneableClassifierTreeG.buildTree(instances, this.m_subtreeRaising);
        return c45PruneableClassifierTreeG;
    }

    private double getEstimatedErrors() {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.localModel().distribution());
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getEstimatedErrors();
        }
        return d;
    }

    private double getEstimatedErrorsForBranch(Instances instances) throws Exception {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(instances));
        }
        Distribution distribution = this.localModel().m_distribution;
        this.localModel().resetDistribution(instances);
        Instances[] instancesArray = this.localModel().split(instances);
        this.localModel().m_distribution = distribution;
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getEstimatedErrorsForBranch(instancesArray[i]);
        }
        return d;
    }

    private double getEstimatedErrorsForDistribution(Distribution distribution) {
        if (Utils.eq(distribution.total(), 0.0)) {
            return 0.0;
        }
        return distribution.numIncorrect() + Stats.addErrs(distribution.total(), distribution.numIncorrect(), this.m_CF);
    }

    private double getTrainingErrors() {
        double d = 0.0;
        if (this.m_isLeaf) {
            return this.localModel().distribution().numIncorrect();
        }
        for (int i = 0; i < this.m_sons.length; ++i) {
            d += this.son(i).getTrainingErrors();
        }
        return d;
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private void newDistribution(Instances instances) throws Exception {
        this.localModel().resetDistribution(instances);
        this.m_train = instances;
        if (!this.m_isLeaf) {
            Instances[] instancesArray = this.localModel().split(instances);
            for (int i = 0; i < this.m_sons.length; ++i) {
                this.son(i).newDistribution(instancesArray[i]);
            }
        } else if (!Utils.eq(instances.sumOfWeights(), 0.0)) {
            this.m_isEmpty = false;
        }
    }

    private C45PruneableClassifierTreeG son(int n) {
        return (C45PruneableClassifierTreeG)this.m_sons[n];
    }

    public void doGrafting(Instances instances) throws Exception {
        double[][] dArray = new double[instances.numAttributes()][2];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            dArray[i][0] = Double.NEGATIVE_INFINITY;
            dArray[i][1] = Double.POSITIVE_INFINITY;
        }
        double[][] dArray2 = new double[2][instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            dArray2[0][i] = 1.0;
            dArray2[1][i] = 1.0;
        }
        this.traverseTree(instances, dArray2, dArray, this, 0.0, -1);
    }

    private void traverseTree(Instances instances, double[][] dArray, double[][] dArray2, C45PruneableClassifierTreeG c45PruneableClassifierTreeG, double d, int n) throws Exception {
        if (this.m_isLeaf) {
            this.findGraft(instances, dArray, dArray2, c45PruneableClassifierTreeG, d, n);
        } else {
            for (int i = 0; i < this.localModel().numSubsets(); ++i) {
                double[][] dArray3 = new double[2][instances.numInstances()];
                for (int j = 0; j < 2; ++j) {
                    System.arraycopy(dArray[j], 0, dArray3[j], 0, dArray[j].length);
                }
                this.sortInstances(instances, dArray3, dArray2, i);
            }
        }
    }

    private void sortInstances(Instances instances, double[][] dArray, double[][] dArray2, int n) throws Exception {
        int n2;
        C45Split c45Split = (C45Split)this.localModel();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray[0].length; ++i) {
            if (dArray[0][i] == 0.0 && dArray[1][i] == 0.0 || instances.instance(i).isMissing(c45Split.attIndex())) continue;
            d += dArray[0][i];
            if (c45Split.whichSubset(instances.instance(i)) != n) {
                if (dArray[0][i] > 0.0) {
                    dArray[1][i] = dArray[0][i];
                    dArray[0][i] = 0.0;
                    continue;
                }
                if (!(dArray[1][i] > 0.0)) continue;
                dArray[1][i] = 0.0;
                continue;
            }
            d2 += dArray[0][i];
        }
        double d3 = d == 0.0 ? 1.0 / (double)c45Split.numSubsets() : d2 / d;
        for (n2 = 0; n2 < dArray[0].length; ++n2) {
            if (dArray[0][n2] == 0.0 && dArray[1][n2] == 0.0 || !instances.instance(n2).isMissing(c45Split.attIndex())) continue;
            double[] dArray3 = dArray[1];
            int n3 = n2;
            dArray3[n3] = dArray3[n3] - (dArray[1][n2] - dArray[0][n2]) * (1.0 - d3);
            double[] dArray4 = dArray[0];
            int n4 = n2;
            dArray4[n4] = dArray4[n4] * d3;
        }
        n2 = this.localModel().distribution().maxClass(n);
        double d4 = (this.localModel().distribution().perClass(n2) + 1.0) / (this.localModel().distribution().total() + 2.0);
        this.son(n).traverseTree(instances, dArray, c45Split.minsAndMaxs(instances, dArray2, n), this, d4, n2);
    }

    private void findGraft(Instances instances, double[][] dArray, double[][] dArray2, ClassifierTree classifierTree, double d, int n) throws Exception {
        Object object;
        int n2;
        int n3;
        int n4;
        int n5 = this.m_isEmpty ? n : this.localModel().distribution().maxClass();
        double d2 = this.m_isEmpty ? d : this.laplaceLeaf(n5);
        Instances instances2 = new Instances(instances, instances.numInstances());
        Instances instances3 = new Instances(instances, instances.numInstances());
        int n6 = 0;
        int n7 = 0;
        for (n4 = 0; n4 < instances.numInstances(); ++n4) {
            if (dArray[0][n4] <= 0.0 && dArray[1][n4] <= 0.0) continue;
            if (dArray[0][n4] != 0.0) {
                instances2.add(instances.instance(n4));
                instances2.instance(n6).setWeight(dArray[0][n4]);
                dArray[0][n6++] = dArray[0][n4];
            }
            if (!(dArray[1][n4] > 0.0)) continue;
            instances3.add(instances.instance(n4));
            instances3.instance(n7).setWeight(dArray[1][n4]);
            dArray[1][n7++] = dArray[1][n4];
        }
        n4 = 0;
        double[] dArray3 = new double[instances3.numClasses()];
        for (n3 = 0; n3 < instances3.numInstances(); ++n3) {
            if (!(dArray[1][n3] > 0.0) || instances3.instance(n3).classIsMissing()) continue;
            int n8 = (int)instances3.instance(n3).classValue();
            dArray3[n8] = dArray3[n8] + dArray[1][n3];
        }
        for (n3 = 0; n3 < instances3.numClasses(); ++n3) {
            double d3 = (dArray3[n3] + 1.0) / (dArray3[n3] + 2.0);
            if (n3 == n5 || !(d3 > d2) || !(this.biprob(dArray3[n3], dArray3[n3], d2) > this.m_BiProbCrit)) continue;
            n4 = 1;
            break;
        }
        if (n4 == 0) {
            return;
        }
        ArrayList<GraftSplit> arrayList = new ArrayList<GraftSplit>();
        for (n2 = 0; n2 < instances3.numAttributes(); ++n2) {
            double d4;
            double d5;
            if (n2 == instances3.classIndex()) continue;
            object = this.sortByAttribute(instances3, n2);
            if (instances3.attribute(n2).isNumeric()) {
                int n9;
                double d6;
                boolean bl = false;
                d5 = Double.POSITIVE_INFINITY;
                d4 = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < instances2.numInstances(); ++i) {
                    if (instances2.instance(i).isMissing(n2) && instances2.instance(i).classValue() == (double)n5) {
                        bl = true;
                        break;
                    }
                    double d7 = instances2.instance(i).value(n2);
                    if (this.m_relabel && instances2.instance(i).classValue() != (double)n5) continue;
                    if (d7 < d5) {
                        d5 = d7;
                    }
                    if (!(d7 > d4)) continue;
                    d4 = d7;
                }
                if (bl) continue;
                double d8 = Double.NaN;
                double d9 = d2;
                double d10 = Double.NaN;
                double d11 = Double.NaN;
                double d12 = Double.NaN;
                double[][] dArray4 = null;
                double[][] dArray5 = new double[2][instances3.numClasses()];
                for (int i = 0; i < instances3.numInstances() && !instances3.instance((int)object[i]).isMissing(n2); ++i) {
                    double d13 = instances3.instance((int)object[i]).value(n2);
                    if (this.m_Debug) {
                        System.out.println("\t " + d13);
                    }
                    if (d13 <= dArray2[n2][0]) {
                        if (!this.m_Debug) continue;
                        System.out.println("\t  <= lowerlim: continuing...");
                        continue;
                    }
                    if (d13 >= d5) {
                        if (!this.m_Debug) break;
                        System.out.println("\t  >= minLeaf; breaking...");
                        break;
                    }
                    double[] dArray6 = dArray5[0];
                    int n10 = (int)instances3.instance((int)object[i]).classValue();
                    dArray6[n10] = dArray6[n10] + dArray[1][object[i]];
                    if (i != instances3.numInstances() - 1) {
                        for (int j = i + 1; j < instances3.numInstances() && instances3.instance((int)object[j]).value(n2) == d13; ++j) {
                            double[] dArray7 = dArray5[0];
                            int n11 = (int)instances3.instance((int)object[++i]).classValue();
                            dArray7[n11] = dArray7[n11] + dArray[1][object[i]];
                        }
                    }
                    double d14 = Utils.sum(dArray5[0]);
                    for (int j = 0; j < instances3.numClasses(); ++j) {
                        d6 = (dArray5[0][j] + 1.0) / (d14 + 2.0);
                        if (!(d6 > d9)) continue;
                        d11 = dArray5[0][j];
                        d12 = d14;
                        d9 = d6;
                        d8 = j;
                        dArray4 = this.copyCounts(dArray5);
                        d10 = i == instances3.numInstances() - 1 ? d13 : (d13 + instances3.instance((int)object[i + 1]).value(n2)) / 2.0;
                    }
                }
                if (!Double.isNaN(d10) && this.biprob(d11, d12, d2) > this.m_BiProbCrit) {
                    GraftSplit graftSplit = null;
                    try {
                        graftSplit = new GraftSplit(n2, d10, 0, (double)n5, dArray4);
                    }
                    catch (Exception exception) {
                        System.err.println("graftsplit error: " + exception.getMessage());
                        System.exit(1);
                    }
                    arrayList.add(graftSplit);
                }
                dArray4 = null;
                double d15 = -1.0;
                double d16 = d2;
                double d17 = Double.NaN;
                d6 = Double.NaN;
                double d18 = Double.NaN;
                double[][] dArray8 = null;
                for (n9 = 0; n9 < instances3.numClasses(); ++n9) {
                    dArray5[0][n9] = 0.0;
                    dArray5[1][n9] = 0.0;
                }
                if (instances3.numInstances() < 1 || !(instances3.instance((int)object[0]).value(n2) < dArray2[n2][1])) continue;
                for (n9 = instances3.numInstances() - 1; n9 >= 0; --n9) {
                    if (instances3.instance((int)object[n9]).isMissing(n2)) continue;
                    double d19 = instances3.instance((int)object[n9]).value(n2);
                    if (this.m_Debug) {
                        System.out.println("\t " + d19);
                    }
                    if (d19 > dArray2[n2][1]) {
                        if (!this.m_Debug) continue;
                        System.out.println("\t  >= upperlim; continuing...");
                        continue;
                    }
                    if (d19 <= d4) {
                        if (!this.m_Debug) break;
                        System.out.println("\t  < maxLeaf; breaking...");
                        break;
                    }
                    double[] dArray9 = dArray5[1];
                    int n12 = (int)instances3.instance((int)object[n9]).classValue();
                    dArray9[n12] = dArray9[n12] + dArray[1][object[n9]];
                    if (n9 != 0 && !instances3.instance((int)object[n9 - 1]).isMissing(n2)) {
                        for (int i = n9 - 1; i >= 0 && instances3.instance((int)object[i]).value(n2) == d19; --i) {
                            double[] dArray10 = dArray5[1];
                            int n13 = (int)instances3.instance((int)object[--n9]).classValue();
                            dArray10[n13] = dArray10[n13] + dArray[1][object[n9]];
                        }
                    }
                    double d20 = Utils.sum(dArray5[1]);
                    for (int i = 0; i < instances3.numClasses(); ++i) {
                        double d21 = (dArray5[1][i] + 1.0) / (d20 + 2.0);
                        if (!(d21 > d16)) continue;
                        d6 = dArray5[1][i];
                        d18 = d20;
                        d16 = d21;
                        d15 = i;
                        dArray8 = this.copyCounts(dArray5);
                        d17 = n9 == 0 ? d19 : (d19 + instances3.instance((int)object[n9 - 1]).value(n2)) / 2.0;
                    }
                }
                if (Double.isNaN(d17) || !(this.biprob(d6, d18, d2) > this.m_BiProbCrit)) continue;
                GraftSplit graftSplit = null;
                try {
                    graftSplit = new GraftSplit(n2, d17, 1, (double)n5, dArray8);
                }
                catch (Exception exception) {
                    System.err.println("graftsplit error:" + exception.getMessage());
                    System.exit(1);
                }
                arrayList.add(graftSplit);
                continue;
            }
            if (dArray2[n2][1] == 1.0) continue;
            boolean[] blArray = new boolean[instances2.attribute(n2).numValues()];
            block20: for (int i = 0; i < instances3.attribute(n2).numValues(); ++i) {
                for (int j = 0; j < instances2.numInstances(); ++j) {
                    if (!instances2.instance(j).isMissing(n2) && instances2.instance(j).value(n2) != (double)i || this.m_relabel && instances2.instance(j).classValue() != (double)n5) continue;
                    blArray[i] = true;
                    continue block20;
                }
            }
            d5 = Double.NaN;
            d4 = Double.NaN;
            double d22 = d2;
            double[][] dArray11 = null;
            double[][] dArray12 = new double[2][instances3.numClasses()];
            for (int i = 0; i < instances3.numInstances(); ++i) {
                if (instances3.instance((int)object[i]).isMissing(n2)) continue;
                for (int j = 0; j < instances3.numClasses(); ++j) {
                    dArray12[0][j] = 0.0;
                }
                double d23 = instances3.instance((int)object[i]).value(n2);
                double[] dArray13 = dArray12[0];
                int n14 = (int)instances3.instance((int)object[i]).classValue();
                dArray13[n14] = dArray13[n14] + dArray[1][object[i]];
                if (i != instances3.numInstances() - 1) {
                    for (int j = i + 1; j < instances3.numInstances() && instances3.instance((int)object[j]).value(n2) == d23; ++j) {
                        double[] dArray14 = dArray12[0];
                        int n15 = (int)instances3.instance((int)object[++i]).classValue();
                        dArray14[n15] = dArray14[n15] + dArray[1][object[i]];
                    }
                }
                if (blArray[(int)d23]) continue;
                double d24 = Utils.sum(dArray12[0]);
                d22 = d2;
                d4 = Double.NaN;
                for (int j = 0; j < instances3.numClasses(); ++j) {
                    double d25 = (dArray12[0][j] + 1.0) / (d24 + 2.0);
                    if (!(d25 > d22) || !(this.biprob(dArray12[0][j], d24, d2) > this.m_BiProbCrit)) continue;
                    d22 = d25;
                    d4 = j;
                    d5 = d23;
                    dArray11 = this.copyCounts(dArray12);
                }
                if (Double.isNaN(d4)) continue;
                GraftSplit graftSplit = null;
                try {
                    graftSplit = new GraftSplit(n2, d5, 2, (double)n5, dArray11);
                }
                catch (Exception exception) {
                    System.err.println("graftsplit error: " + exception.getMessage());
                    System.exit(1);
                }
                arrayList.add(graftSplit);
            }
        }
        Collections.sort(arrayList);
        for (n2 = 0; n2 < arrayList.size() && ((GraftSplit)(object = (Object)((GraftSplit)arrayList.get(n2)))).maxClassForSubsetOfInterest() == n5; ++n2) {
            arrayList.remove(n2);
            --n2;
        }
        if (arrayList.size() < 1) {
            return;
        }
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            object = (GraftSplit)arrayList.get(n2);
            try {
                ((GraftSplit)object).buildClassifier(instances2);
                ((GraftSplit)object).deleteGraftedCases(instances2);
                continue;
            }
            catch (Exception exception) {
                System.err.println("graftsplit build error: " + exception.getMessage());
            }
        }
        ((C45PruneableClassifierTreeG)classifierTree).setDescendents(arrayList, this);
    }

    private int[] sortByAttribute(Instances instances, int n) {
        double[] dArray = instances.attributeToDoubleArray(n);
        int[] nArray = Utils.sort(dArray);
        return nArray;
    }

    private double[][] copyCounts(double[][] dArray) {
        double[][] dArray2 = new double[dArray.length][0];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = new double[dArray[i].length];
            for (int j = 0; j < dArray[i].length; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return dArray2;
    }

    private double getProbsLaplace(int n, Instance instance, double d) throws Exception {
        double d2 = 0.0;
        if (this.m_isLeaf) {
            return d * this.localModel().classProbLaplace(n, instance, -1);
        }
        int n2 = this.localModel().whichSubset(instance);
        if (n2 == -1) {
            double[] dArray = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                if (!this.son((int)i).m_isLeaf) {
                    d2 += this.son(i).getProbsLaplace(n, instance, dArray[i] * d);
                    continue;
                }
                d2 += d * dArray[i] * this.localModel().classProbLaplace(n, instance, i);
            }
            return d2;
        }
        if (this.son((int)n2).m_isLeaf) {
            return d * this.localModel().classProbLaplace(n, instance, n2);
        }
        return this.son(n2).getProbsLaplace(n, instance, d);
    }

    private double getProbs(int n, Instance instance, double d) throws Exception {
        double d2 = 0.0;
        if (this.m_isLeaf) {
            return d * this.localModel().classProb(n, instance, -1);
        }
        int n2 = this.localModel().whichSubset(instance);
        if (n2 == -1) {
            double[] dArray = this.localModel().weights(instance);
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (this.son((int)i).m_isEmpty) continue;
                d2 += this.son(i).getProbs(n, instance, dArray[i] * d);
            }
            return d2;
        }
        if (this.son((int)n2).m_isEmpty) {
            return d * this.localModel().classProb(n, instance, n2);
        }
        return this.son(n2).getProbs(n, instance, d);
    }

    public void setDescendents(ArrayList arrayList, C45PruneableClassifierTreeG c45PruneableClassifierTreeG) {
        NoSplit noSplit;
        C45PruneableClassifierTreeG c45PruneableClassifierTreeG2;
        Instances instances = new Instances(this.m_train, 0);
        boolean bl = false;
        ClassifierSplitModel classifierSplitModel = null;
        if (arrayList.size() > 0) {
            classifierSplitModel = (ClassifierSplitModel)arrayList.remove(arrayList.size() - 1);
            c45PruneableClassifierTreeG2 = new C45PruneableClassifierTreeG(this.m_toSelectModel, instances, classifierSplitModel, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, false, this.m_relabel, this.m_cleanup);
        } else {
            noSplit = ((GraftSplit)this.localModel()).getOtherLeaf();
            c45PruneableClassifierTreeG2 = new C45PruneableClassifierTreeG(this.m_toSelectModel, instances, noSplit, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, true, this.m_relabel, this.m_cleanup);
            bl = true;
        }
        if (this.m_sons != null) {
            for (int i = 0; i < this.m_sons.length; ++i) {
                if (!this.son(i).equals(c45PruneableClassifierTreeG)) continue;
                this.m_sons[i] = c45PruneableClassifierTreeG2;
            }
        } else {
            this.m_sons = new C45PruneableClassifierTreeG[this.localModel().numSubsets()];
            noSplit = ((GraftSplit)this.localModel()).getLeaf();
            C45PruneableClassifierTreeG c45PruneableClassifierTreeG3 = new C45PruneableClassifierTreeG(this.m_toSelectModel, instances, noSplit, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, true, this.m_relabel, this.m_cleanup);
            if (((GraftSplit)this.localModel()).subsetOfInterest() == 0) {
                this.m_sons[0] = c45PruneableClassifierTreeG3;
                this.m_sons[1] = c45PruneableClassifierTreeG2;
            } else {
                this.m_sons[0] = c45PruneableClassifierTreeG2;
                this.m_sons[1] = c45PruneableClassifierTreeG3;
            }
        }
        if (!bl) {
            c45PruneableClassifierTreeG2.setDescendents(arrayList, c45PruneableClassifierTreeG);
        }
    }

    private double laplaceLeaf(double d) {
        double d2 = (this.localModel().distribution().perClass((int)d) + 1.0) / (this.localModel().distribution().total() + 2.0);
        return d2;
    }

    public double biprob(double d, double d2, double d3) throws Exception {
        return (d - 0.5 - d2 * d3) / Math.sqrt(d2 * d3 * (1.0 - d3));
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_isLeaf) {
                stringBuffer.append(": ");
                if (this.m_localModel instanceof GraftSplit) {
                    stringBuffer.append(((GraftSplit)this.m_localModel).dumpLabelG(0, this.m_train));
                } else {
                    stringBuffer.append(this.m_localModel.dumpLabel(0, this.m_train));
                }
            } else {
                this.dumpTree(0, stringBuffer);
            }
            stringBuffer.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            stringBuffer.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print classification tree.";
        }
    }

    protected void dumpTree(int n, StringBuffer stringBuffer) throws Exception {
        for (int i = 0; i < this.m_sons.length; ++i) {
            stringBuffer.append("\n");
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("|   ");
            }
            stringBuffer.append(this.m_localModel.leftSide(this.m_train));
            stringBuffer.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                stringBuffer.append(": ");
                if (this.m_localModel instanceof GraftSplit) {
                    stringBuffer.append(((GraftSplit)this.m_localModel).dumpLabelG(i, this.m_train));
                    continue;
                }
                stringBuffer.append(this.m_localModel.dumpLabel(i, this.m_train));
                continue;
            }
            ((C45PruneableClassifierTreeG)this.m_sons[i]).dumpTree(n + 1, stringBuffer);
        }
    }
}

