/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.DataObjects;

import java.io.Serializable;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ManhattanDataObject
implements DataObject,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3417720553766544582L;
    private Instance instance;
    private String key;
    private int clusterID;
    private boolean processed;
    private double c_dist;
    private double r_dist;
    private Database database;

    public ManhattanDataObject(Instance instance, String string, Database database) {
        this.database = database;
        this.key = string;
        this.instance = instance;
        this.clusterID = -1;
        this.processed = false;
        this.c_dist = 2.147483647E9;
        this.r_dist = 2.147483647E9;
    }

    public boolean equals(DataObject dataObject) {
        if (this == dataObject) {
            return true;
        }
        if (!(dataObject instanceof ManhattanDataObject)) {
            return false;
        }
        ManhattanDataObject manhattanDataObject = (ManhattanDataObject)dataObject;
        if (this.getInstance().equalHeaders(manhattanDataObject.getInstance())) {
            for (int i = 0; i < this.getInstance().numValues(); ++i) {
                double d;
                double d2 = this.getInstance().valueSparse(i);
                if (d2 == (d = manhattanDataObject.getInstance().valueSparse(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public double distance(DataObject dataObject) {
        double d = 0.0;
        if (!(dataObject instanceof ManhattanDataObject)) {
            return Double.NaN;
        }
        if (this.getInstance().equalHeaders(dataObject.getInstance())) {
            for (int i = 0; i < this.getInstance().numValues(); ++i) {
                double d2 = this.computeDistance(this.getInstance().index(i), this.getInstance().valueSparse(i), dataObject.getInstance().valueSparse(i));
                d += Math.abs(d2);
            }
            return d;
        }
        return Double.NaN;
    }

    private double computeDistance(int n, double d, double d2) {
        switch (this.getInstance().attribute(n).type()) {
            case 1: {
                return Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2 ? 1.0 : 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        return 1.0;
                    }
                    return Instance.isMissingValue(d) ? this.norm(d2, n) : this.norm(d, n);
                }
                return this.norm(d, n) - this.norm(d2, n);
            }
        }
        return 0.0;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.database.getAttributeMinValues()[n]) || Utils.eq(this.database.getAttributeMaxValues()[n], this.database.getAttributeMinValues()[n])) {
            return 0.0;
        }
        return (d - this.database.getAttributeMinValues()[n]) / (this.database.getAttributeMaxValues()[n] - this.database.getAttributeMinValues()[n]);
    }

    public Instance getInstance() {
        return this.instance;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setClusterLabel(int n) {
        this.clusterID = n;
    }

    public int getClusterLabel() {
        return this.clusterID;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setCoreDistance(double d) {
        this.c_dist = d;
    }

    public double getCoreDistance() {
        return this.c_dist;
    }

    public void setReachabilityDistance(double d) {
        this.r_dist = d;
    }

    public double getReachabilityDistance() {
        return this.r_dist;
    }

    public String toString() {
        return this.instance.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

