/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import weka.core.RevisionUtils;
import weka.core.stemmers.LovinsStemmer;
import weka.core.stemmers.Stemming;

public class IteratedLovinsStemmer
extends LovinsStemmer {
    static final long serialVersionUID = 960689687163788264L;

    public String globalInfo() {
        return "An iterated version of the Lovins stemmer. It stems the word (in case it's longer than 2 characters) until it no further changes.\n\nFor more information about the Lovins stemmer see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String stem(String string) {
        if (string.length() <= 2) {
            return string;
        }
        String string2 = super.stem(string);
        while (!string2.equals(string)) {
            string = string2;
            string2 = super.stem(string2);
        }
        return string2;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }

    public static void main(String[] stringArray) {
        try {
            Stemming.useStemmer(new IteratedLovinsStemmer(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

