/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class ReplaceMissingValues
extends PotentialClassIgnorer
implements UnsupervisedFilter,
Sourcable {
    static final long serialVersionUID = 8349568310991609867L;
    private double[] m_ModesAndMeans = null;

    public String globalInfo() {
        return "Replaces all missing values for nominal and numeric attributes in a dataset with the modes and means from the training data.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_ModesAndMeans = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_ModesAndMeans == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_ModesAndMeans == null) {
            int n;
            double d = this.getInputFormat().sumOfWeights();
            double[][] dArrayArray = new double[this.getInputFormat().numAttributes()][];
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (!this.getInputFormat().attribute(i).isNominal()) continue;
                dArrayArray[i] = new double[this.getInputFormat().attribute(i).numValues()];
                if (dArrayArray[i].length <= 0) continue;
                dArrayArray[i][0] = d;
            }
            double[] dArray = new double[this.getInputFormat().numAttributes()];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = d;
            }
            double[] dArray2 = new double[this.getInputFormat().numAttributes()];
            for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
                Instance instance = this.getInputFormat().instance(n);
                for (int i = 0; i < instance.numValues(); ++i) {
                    if (!instance.isMissingSparse(i)) {
                        double d2 = instance.valueSparse(i);
                        if (instance.attributeSparse(i).isNominal()) {
                            if (dArrayArray[instance.index(i)].length <= 0) continue;
                            double[] dArray3 = dArrayArray[instance.index(i)];
                            int n2 = (int)d2;
                            dArray3[n2] = dArray3[n2] + instance.weight();
                            double[] dArray4 = dArrayArray[instance.index(i)];
                            dArray4[0] = dArray4[0] - instance.weight();
                            continue;
                        }
                        if (!instance.attributeSparse(i).isNumeric()) continue;
                        int n3 = instance.index(i);
                        dArray2[n3] = dArray2[n3] + instance.weight() * instance.valueSparse(i);
                        continue;
                    }
                    if (instance.attributeSparse(i).isNominal()) {
                        if (dArrayArray[instance.index(i)].length <= 0) continue;
                        double[] dArray5 = dArrayArray[instance.index(i)];
                        dArray5[0] = dArray5[0] - instance.weight();
                        continue;
                    }
                    if (!instance.attributeSparse(i).isNumeric()) continue;
                    int n4 = instance.index(i);
                    dArray[n4] = dArray[n4] - instance.weight();
                }
            }
            this.m_ModesAndMeans = new double[this.getInputFormat().numAttributes()];
            for (n = 0; n < this.getInputFormat().numAttributes(); ++n) {
                if (this.getInputFormat().attribute(n).isNominal()) {
                    if (dArrayArray[n].length == 0) {
                        this.m_ModesAndMeans[n] = Instance.missingValue();
                        continue;
                    }
                    this.m_ModesAndMeans[n] = Utils.maxIndex(dArrayArray[n]);
                    continue;
                }
                if (!this.getInputFormat().attribute(n).isNumeric() || !Utils.gr(dArray[n], 0.0)) continue;
                this.m_ModesAndMeans[n] = dArray2[n] / dArray[n];
            }
            for (n = 0; n < this.getInputFormat().numInstances(); ++n) {
                this.convertInstance(this.getInputFormat().instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        Instance instance2 = null;
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numValues()];
            int[] nArray = new int[instance.numValues()];
            int n = 0;
            for (int i = 0; i < instance.numValues(); ++i) {
                if (instance.isMissingSparse(i) && this.getInputFormat().classIndex() != instance.index(i) && (instance.attributeSparse(i).isNominal() || instance.attributeSparse(i).isNumeric())) {
                    if (this.m_ModesAndMeans[instance.index(i)] == 0.0) continue;
                    dArray[n] = this.m_ModesAndMeans[instance.index(i)];
                    nArray[n] = instance.index(i);
                    ++n;
                    continue;
                }
                dArray[n] = instance.valueSparse(i);
                nArray[n] = instance.index(i);
                ++n;
            }
            if (n == instance.numValues()) {
                instance2 = new SparseInstance(instance.weight(), dArray, nArray, instance.numAttributes());
            } else {
                double[] dArray2 = new double[n];
                int[] nArray2 = new int[n];
                System.arraycopy(dArray, 0, dArray2, 0, n);
                System.arraycopy(nArray, 0, nArray2, 0, n);
                instance2 = new SparseInstance(instance.weight(), dArray2, nArray2, instance.numAttributes());
            }
        } else {
            double[] dArray = new double[this.getInputFormat().numAttributes()];
            for (int i = 0; i < instance.numAttributes(); ++i) {
                dArray[i] = instance.isMissing(i) && this.getInputFormat().classIndex() != i && (this.getInputFormat().attribute(i).isNominal() || this.getInputFormat().attribute(i).isNumeric()) ? this.m_ModesAndMeans[i] : instance.value(i);
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public String toSource(String string, Instances instances) throws Exception {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean[] blArray = new boolean[instances.numAttributes()];
        boolean[] blArray2 = new boolean[instances.numAttributes()];
        String[] stringArray = new String[instances.numAttributes()];
        double[] dArray = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            blArray[n] = instances.attribute(n).isNumeric() && n != instances.classIndex();
            blArray2[n] = instances.attribute(n).isNominal() && n != instances.classIndex();
            dArray[n] = blArray[n] ? this.m_ModesAndMeans[n] : Double.NaN;
            stringArray[n] = blArray2[n] ? instances.attribute(n).value((int)this.m_ModesAndMeans[n]) : null;
        }
        stringBuffer.append("class " + string + " {\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** lists which numeric attributes will be processed */\n");
        stringBuffer.append("  protected final static boolean[] NUMERIC = new boolean[]{" + Utils.arrayToString(blArray) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** lists which nominal attributes will be processed */\n");
        stringBuffer.append("  protected final static boolean[] NOMINAL = new boolean[]{" + Utils.arrayToString(blArray2) + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the means */\n");
        stringBuffer.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(dArray).replaceAll("NaN", "Double.NaN") + "};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /** the modes */\n");
        stringBuffer.append("  protected final static String[] MODES = new String[]{");
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            if (blArray2[n]) {
                stringBuffer.append("\"" + Utils.quote(stringArray[n]) + "\"");
                continue;
            }
            stringBuffer.append(stringArray[n]);
        }
        stringBuffer.append("};\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters a single row\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the row to process\n");
        stringBuffer.append("   * @return the processed row\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[] filter(Object[] i) {\n");
        stringBuffer.append("    Object[] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      if (i[n] == null) {\n");
        stringBuffer.append("        if (NUMERIC[n])\n");
        stringBuffer.append("          result[n] = MEANS[n];\n");
        stringBuffer.append("        else if (NOMINAL[n])\n");
        stringBuffer.append("          result[n] = MODES[n];\n");
        stringBuffer.append("        else\n");
        stringBuffer.append("          result[n] = i[n];\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("      else {\n");
        stringBuffer.append("        result[n] = i[n];\n");
        stringBuffer.append("      }\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("\n");
        stringBuffer.append("  /**\n");
        stringBuffer.append("   * filters multiple rows\n");
        stringBuffer.append("   * \n");
        stringBuffer.append("   * @param i the rows to process\n");
        stringBuffer.append("   * @return the processed rows\n");
        stringBuffer.append("   */\n");
        stringBuffer.append("  public static Object[][] filter(Object[][] i) {\n");
        stringBuffer.append("    Object[][] result;\n");
        stringBuffer.append("\n");
        stringBuffer.append("    result = new Object[i.length][];\n");
        stringBuffer.append("    for (int n = 0; n < i.length; n++) {\n");
        stringBuffer.append("      result[n] = filter(i[n]);\n");
        stringBuffer.append("    }\n");
        stringBuffer.append("\n");
        stringBuffer.append("    return result;\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5547 $");
    }

    public static void main(String[] stringArray) {
        ReplaceMissingValues.runFilter(new ReplaceMissingValues(), stringArray);
    }
}

