/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.Classifier;
import weka.classifiers.pmml.consumer.GeneralRegression;
import weka.classifiers.pmml.consumer.NeuralNetwork;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.classifiers.pmml.consumer.Regression;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLModel;
import weka.core.pmml.TransformationDictionary;
import weka.gui.Logger;

public class PMMLFactory {
    public static PMMLModel getPMMLModel(String string) throws Exception {
        return PMMLFactory.getPMMLModel(string, null);
    }

    public static PMMLModel getPMMLModel(File file) throws Exception {
        return PMMLFactory.getPMMLModel(file, null);
    }

    public static PMMLModel getPMMLModel(InputStream inputStream) throws Exception {
        return PMMLFactory.getPMMLModel(inputStream, null);
    }

    public static PMMLModel getPMMLModel(String string, Logger logger) throws Exception {
        return PMMLFactory.getPMMLModel(new File(string), logger);
    }

    public static PMMLModel getPMMLModel(File file, Logger logger) throws Exception {
        return PMMLFactory.getPMMLModel(new BufferedInputStream(new FileInputStream(file)), logger);
    }

    private static boolean isPMML(Document document) {
        NodeList nodeList = document.getElementsByTagName("PMML");
        return nodeList.getLength() != 0;
    }

    public static PMMLModel getPMMLModel(InputStream inputStream, Logger logger) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        document.getDocumentElement().normalize();
        if (!PMMLFactory.isPMML(document)) {
            throw new IllegalArgumentException("[PMMLFactory] Source is not a PMML file!!");
        }
        Instances instances = PMMLFactory.getDataDictionaryAsInstances(document);
        TransformationDictionary transformationDictionary = PMMLFactory.getTransformationDictionary(document, instances);
        ModelType modelType = PMMLFactory.getModelType(document);
        if (modelType == ModelType.UNKNOWN_MODEL) {
            throw new Exception("Unsupported PMML model type");
        }
        Element element = PMMLFactory.getModelElement(document, modelType);
        MiningSchema miningSchema = new MiningSchema(element, instances, transformationDictionary);
        PMMLModel pMMLModel = PMMLFactory.getModelInstance(document, modelType, element, instances, miningSchema);
        if (logger != null) {
            pMMLModel.setLog(logger);
        }
        return pMMLModel;
    }

    protected static TransformationDictionary getTransformationDictionary(Document document, Instances instances) throws Exception {
        Node node;
        TransformationDictionary transformationDictionary = null;
        NodeList nodeList = document.getElementsByTagName("TransformationDictionary");
        if (nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            transformationDictionary = new TransformationDictionary((Element)node, instances);
        }
        return transformationDictionary;
    }

    public static void serializePMMLModel(PMMLModel pMMLModel, String string) throws Exception {
        PMMLFactory.serializePMMLModel(pMMLModel, new File(string));
    }

    public static void serializePMMLModel(PMMLModel pMMLModel, File file) throws Exception {
        PMMLFactory.serializePMMLModel(pMMLModel, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public static void serializePMMLModel(PMMLModel pMMLModel, OutputStream outputStream) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        Instances instances = pMMLModel.getMiningSchema().getFieldsAsInstances();
        objectOutputStream.writeObject(instances);
        objectOutputStream.writeObject(pMMLModel);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    protected static PMMLModel getModelInstance(Document document, ModelType modelType, Element element, Instances instances, MiningSchema miningSchema) throws Exception {
        PMMLClassifier pMMLClassifier = null;
        switch (modelType) {
            case REGRESSION_MODEL: {
                pMMLClassifier = new Regression(element, instances, miningSchema);
                break;
            }
            case GENERAL_REGRESSION_MODEL: {
                pMMLClassifier = new GeneralRegression(element, instances, miningSchema);
                break;
            }
            case NEURAL_NETWORK_MODEL: {
                pMMLClassifier = new NeuralNetwork(element, instances, miningSchema);
                break;
            }
            default: {
                throw new Exception("[PMMLFactory] Unknown model type!!");
            }
        }
        pMMLClassifier.setPMMLVersion(document);
        pMMLClassifier.setCreatorApplication(document);
        return pMMLClassifier;
    }

    protected static ModelType getModelType(Document document) {
        NodeList nodeList = document.getElementsByTagName("RegressionModel");
        if (nodeList.getLength() > 0) {
            return ModelType.REGRESSION_MODEL;
        }
        nodeList = document.getElementsByTagName("GeneralRegressionModel");
        if (nodeList.getLength() > 0) {
            return ModelType.GENERAL_REGRESSION_MODEL;
        }
        nodeList = document.getElementsByTagName("NeuralNetwork");
        if (nodeList.getLength() > 0) {
            return ModelType.NEURAL_NETWORK_MODEL;
        }
        return ModelType.UNKNOWN_MODEL;
    }

    protected static Element getModelElement(Document document, ModelType modelType) throws Exception {
        Node node;
        NodeList nodeList = null;
        Element element = null;
        switch (modelType) {
            case REGRESSION_MODEL: {
                nodeList = document.getElementsByTagName("RegressionModel");
                break;
            }
            case GENERAL_REGRESSION_MODEL: {
                nodeList = document.getElementsByTagName("GeneralRegressionModel");
                break;
            }
            case NEURAL_NETWORK_MODEL: {
                nodeList = document.getElementsByTagName("NeuralNetwork");
                break;
            }
            default: {
                throw new Exception("[PMMLFactory] unknown/unsupported model type.");
            }
        }
        if (nodeList != null && nodeList.getLength() > 0 && (node = nodeList.item(0)).getNodeType() == 1) {
            element = (Element)node;
        }
        return element;
    }

    protected static Instances getMiningSchemaAsInstances(Element element, Instances instances) throws Exception {
        FastVector fastVector = new FastVector();
        NodeList nodeList = element.getElementsByTagName("MiningField");
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("usageType");
            Attribute attribute = instances.attribute(string);
            if (attribute != null) {
                if (string2.length() == 0 || string2.equals("active") || string2.equals("predicted")) {
                    fastVector.addElement(attribute);
                    ++n2;
                }
                if (!string2.equals("predicted")) continue;
                n = n2 - 1;
                continue;
            }
            throw new Exception("Can't find mining field: " + string + " in the data dictionary.");
        }
        Instances instances2 = new Instances("miningSchema", fastVector, 0);
        if (n != -1) {
            instances2.setClassIndex(n);
        }
        return instances2;
    }

    protected static Instances getDataDictionaryAsInstances(Document document) throws Exception {
        FastVector fastVector = new FastVector();
        NodeList nodeList = document.getElementsByTagName("DataField");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String string = element.getAttribute("name");
            String string2 = element.getAttribute("optype");
            Attribute attribute = null;
            if (string == null || string2 == null) continue;
            if (string2.equals("continuous")) {
                attribute = new Attribute(string);
            } else if (string2.equals("categorical") || string2.equals("ordinal")) {
                FastVector fastVector2;
                NodeList nodeList2 = element.getElementsByTagName("Value");
                if (nodeList2 == null || nodeList2.getLength() == 0) {
                    fastVector2 = null;
                    attribute = new Attribute(string, fastVector2);
                } else {
                    fastVector2 = new FastVector();
                    for (int j = 0; j < nodeList2.getLength(); ++j) {
                        String string3;
                        Node node2 = nodeList2.item(j);
                        if (node2.getNodeType() != 1 || (string3 = ((Element)node2).getAttribute("property")) != null && string3.length() != 0 && !string3.equals("valid")) continue;
                        String string4 = ((Element)node2).getAttribute("value");
                        fastVector2.addElement(string4);
                    }
                    attribute = new Attribute(string, fastVector2);
                }
            } else {
                throw new Exception("[PMMLFactory] can't handle " + string2 + "attributes.");
            }
            fastVector.addElement(attribute);
        }
        Instances instances = new Instances("dataDictionary", fastVector, 0);
        return instances;
    }

    public static String applyClassifier(PMMLModel pMMLModel, Instances instances) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (!(pMMLModel instanceof PMMLClassifier)) {
            throw new Exception("PMML model is not a classifier!");
        }
        double[] dArray = null;
        PMMLClassifier pMMLClassifier = (PMMLClassifier)pMMLModel;
        for (int i = 0; i < instances.numInstances(); ++i) {
            stringBuffer.append("Actual: ");
            Instance instance = instances.instance(i);
            if (instance.classAttribute().isNumeric()) {
                stringBuffer.append(instance.value(instance.classIndex()) + " ");
            } else {
                stringBuffer.append(instance.classAttribute().value((int)instance.value(instance.classIndex())) + " ");
            }
            dArray = pMMLClassifier.distributionForInstance(instance);
            stringBuffer.append(" Predicted: ");
            for (int j = 0; j < dArray.length; ++j) {
                stringBuffer.append("" + dArray[j] + " ");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            String string = Utils.getOption('l', stringArray2);
            if (string.length() == 0) {
                throw new Exception("[PMMLFactory] must specify a PMML file using the -l option.");
            }
            PMMLModel pMMLModel = PMMLFactory.getPMMLModel(string, null);
            PMMLClassifierRunner pMMLClassifierRunner = new PMMLClassifierRunner();
            pMMLClassifierRunner.evaluatePMMLClassifier(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class PMMLClassifierRunner
    extends Classifier {
        private PMMLClassifierRunner() {
        }

        public double[] distributionForInstance(Instance instance) throws Exception {
            throw new Exception("Don't call this method!!");
        }

        public void buildClassifier(Instances instances) throws Exception {
            throw new Exception("Don't call this method!!");
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5562 $");
        }

        public void evaluatePMMLClassifier(String[] stringArray) {
            PMMLClassifierRunner.runClassifier(this, stringArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ModelType {
        UNKNOWN_MODEL("unknown"),
        REGRESSION_MODEL("Regression"),
        GENERAL_REGRESSION_MODEL("GeneralRegression"),
        NEURAL_NETWORK_MODEL("NeuralNetwork");

        private final String m_stringVal;

        private ModelType(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

