/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stopwords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.stopwords.AbstractStopwords;
import weka.core.stopwords.StopwordsHandler;

public class MultiStopwords
extends AbstractStopwords {
    private static final long serialVersionUID = -8568762652879773063L;
    protected StopwordsHandler[] m_Stopwords = new StopwordsHandler[0];

    @Override
    public String globalInfo() {
        return "Applies the specified stopwords algorithms one after other.\nAs soon as a word has been identified as stopword, the loop is exited.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration<Option> enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\t" + this.stopwordsTipText() + "\n" + "\t(default: none)", "stopwords", 1, "-stopwords <classname + options>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        ArrayList<StopwordsHandler> handlers = new ArrayList<StopwordsHandler>();
        do {
            if ((tmpStr = Utils.getOption("stopwords", options)).isEmpty()) continue;
            String[] tmpOptions = Utils.splitOptions(tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            handlers.add((StopwordsHandler)Utils.forName(StopwordsHandler.class, tmpStr, tmpOptions));
        } while (!tmpStr.isEmpty());
        this.setStopwords(handlers.toArray(new StopwordsHandler[handlers.size()]));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(super.getOptions()));
        for (StopwordsHandler handler : this.m_Stopwords) {
            options.add("-stopwords");
            options.add(Utils.toCommandLine(handler));
        }
        return options.toArray(new String[options.size()]);
    }

    public void setStopwords(StopwordsHandler[] value) {
        this.m_Stopwords = value;
        this.reset();
    }

    public StopwordsHandler[] getStopwords() {
        return this.m_Stopwords;
    }

    public String stopwordsTipText() {
        return "The stopwords algorithms to apply sequentially.";
    }

    @Override
    protected boolean is(String word) {
        boolean result = false;
        for (StopwordsHandler handler : this.m_Stopwords) {
            if (!handler.isStopword(word)) continue;
            result = true;
            break;
        }
        return result;
    }
}

