\name{RadOnc}
\alias{johndoe}
\alias{janedoe}
\alias{janedoe.RTdata}
\alias{cord}
\alias{mandible}
\alias{teeth}
\alias{RadOnc-data}
\docType{data}
\title{
DVH data for 'John Doe' and 'Jane Doe'; 3D structural data for 'cord', 'mandible', and 'teeth'; RT data for 'Jane Doe'
}
\description{
List of 10 DVH objects corresponding to structures (e.g. liver) for patients 'John Doe' and 'Jane Doe'; Two structure3D objects ('cord' and 'mandible') and one structure list ('teeth') containing 3 structures; an RTdata object for 'Jane Doe' containing dose grid information and a structure list with 3 structures.}
\usage{data(package="RadOnc")}
\format{
  The format for \code{johndoe} is:
\preformatted{
Formal class 'DVH.list' [package "RadOnc"] with 1 slots
  ..@ structures:List of 10
  .. ..$ LIVER       :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "LIVER"
  .. .. .. ..@ structure.volume: num 1367
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 92.9
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 4.9
  .. .. .. ..@ dose.median     : num 0
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 10.8
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 1367 414 392 378 368 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ SMALL_BOWEL :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "SMALL_BOWEL"
  .. .. .. ..@ structure.volume: num 206
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 99.8
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 4.3
  .. .. .. ..@ dose.median     : num 0
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 15.3
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 206.2 43.1 39.5 37.4 35.8 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ DUODENUM    :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "DUODENUM"
  .. .. .. ..@ structure.volume: num 93.1
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 102
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 70.7
  .. .. .. ..@ dose.median     : num 81.3
  .. .. .. ..@ dose.mode       : num 100
  .. .. .. ..@ dose.STD        : num 30.3
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 93.1 93.1 93 93 92.9 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ STOMACH     :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "STOMACH"
  .. .. .. ..@ structure.volume: num 304
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 101
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 7.9
  .. .. .. ..@ dose.median     : num 0
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 22.8
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 303.6 78 71.5 67.8 65.1 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ CTV         :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "CTV"
  .. .. .. ..@ structure.volume: num 88.4
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 103
  .. .. .. ..@ dose.min        : num 96.8
  .. .. .. ..@ dose.mean       : num 100
  .. .. .. ..@ dose.median     : num 100
  .. .. .. ..@ dose.mode       : num 100
  .. .. .. ..@ dose.STD        : num 0.7
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 88.4 88.4 88.4 88.4 88.4 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ PTV         :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "PTV"
  .. .. .. ..@ structure.volume: num 156
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 103
  .. .. .. ..@ dose.min        : num 84.1
  .. .. .. ..@ dose.mean       : num 99.6
  .. .. .. ..@ dose.median     : num 99.8
  .. .. .. ..@ dose.mode       : num 99.9
  .. .. .. ..@ dose.STD        : num 1.2
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 156 156 156 156 156 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ BODY        :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "BODY"
  .. .. .. ..@ structure.volume: num 17666
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 103
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 5.6
  .. .. .. ..@ dose.median     : num 0
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 17.1
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 17666 3424 3290 3206 3143 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ LEFT_KIDNEY :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "LEFT_KIDNEY"
  .. .. .. ..@ structure.volume: num 154
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 44.4
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 4.7
  .. .. .. ..@ dose.median     : num 0
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 9.5
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 154.2 48.3 46.4 45.3 44.4 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ RIGHT_KIDNEY:Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "RIGHT_KIDNEY"
  .. .. .. ..@ structure.volume: num 155
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 98.5
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 24.2
  .. .. .. ..@ dose.median     : num 24.3
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 22.8
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 155 134 132 130 129 ...
  .. .. .. ..@ volume.type     : chr "absolute"
  .. ..$ CORD        :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "John Doe"
  .. .. .. ..@ ID			   : chr "5555555555"
  .. .. .. ..@ structure.name  : chr "CORD"
  .. .. .. ..@ structure.volume: num 40.7
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 55.5
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 20.7
  .. .. .. ..@ dose.median     : num 4.1
  .. .. .. ..@ dose.mode       : num 0
  .. .. .. ..@ dose.STD        : num 23.2
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1026] 0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 ...
  .. .. .. ..@ dose.type       : chr "relative"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1026] 40.7 23 22.7 22.4 22.2 ...
  .. .. .. ..@ volume.type     : chr "absolute"
}

  The format for \code{janedoe} is:
\preformatted{
Formal class 'DVH.list' [package "RadOnc"] with 1 slots
  ..@ structures:List of 10
  .. ..$ LIVER       :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "LIVER"
  .. .. .. ..@ structure.volume: num 1636
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5634
  .. .. .. ..@ dose.min        : num 42.7
  .. .. .. ..@ dose.mean       : num 707
  .. .. .. ..@ dose.median     : num 276
  .. .. .. ..@ dose.mode       : num 99.5
  .. .. .. ..@ dose.STD        : num 917
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ LEFT_KIDNEY :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "LEFT_KIDNEY"
  .. .. .. ..@ structure.volume: num 196
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 3847
  .. .. .. ..@ dose.min        : num 75.8
  .. .. .. ..@ dose.mean       : num 1021
  .. .. .. ..@ dose.median     : num 703
  .. .. .. ..@ dose.mode       : num 119
  .. .. .. ..@ dose.STD        : num 802
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ STOMACH     :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "STOMACH"
  .. .. .. ..@ structure.volume: num 695
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5353
  .. .. .. ..@ dose.min        : num 59
  .. .. .. ..@ dose.mean       : num 1280
  .. .. .. ..@ dose.median     : num 1302
  .. .. .. ..@ dose.mode       : num 111
  .. .. .. ..@ dose.STD        : num 1062
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ DUODENUM    :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "DUODENUM"
  .. .. .. ..@ structure.volume: num 34.2
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5620
  .. .. .. ..@ dose.min        : num 2708
  .. .. .. ..@ dose.mean       : num 4755
  .. .. .. ..@ dose.median     : num 4943
  .. .. .. ..@ dose.mode       : num 5365
  .. .. .. ..@ dose.STD        : num 635
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ RIGHT_KIDNEY:Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "RIGHT_KIDNEY"
  .. .. .. ..@ structure.volume: num 224
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 4202
  .. .. .. ..@ dose.min        : num 102
  .. .. .. ..@ dose.mean       : num 1511
  .. .. .. ..@ dose.median     : num 1624
  .. .. .. ..@ dose.mode       : num 1638
  .. .. .. ..@ dose.STD        : num 714
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ CTV         :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "CTV"
  .. .. .. ..@ structure.volume: num 147
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5647
  .. .. .. ..@ dose.min        : num 5169
  .. .. .. ..@ dose.mean       : num 5500
  .. .. .. ..@ dose.median     : num 5505
  .. .. .. ..@ dose.mode       : num 5500
  .. .. .. ..@ dose.STD        : num 59.8
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ PTV         :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "PTV"
  .. .. .. ..@ structure.volume: num 239
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5665
  .. .. .. ..@ dose.min        : num 4750
  .. .. .. ..@ dose.mean       : num 5471
  .. .. .. ..@ dose.median     : num 5493
  .. .. .. ..@ dose.mode       : num 5500
  .. .. .. ..@ dose.STD        : num 98.6
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ SMALL_BOWEL :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "SMALL_BOWEL"
  .. .. .. ..@ structure.volume: num 232
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 4934
  .. .. .. ..@ dose.min        : num 59.6
  .. .. .. ..@ dose.mean       : num 294
  .. .. .. ..@ dose.median     : num 171
  .. .. .. ..@ dose.mode       : num 127
  .. .. .. ..@ dose.STD        : num 391
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 100 100 100 100 100 100 100 100 100 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ CORD        :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "CORD"
  .. .. .. ..@ structure.volume: num 64.9
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 3443
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 732
  .. .. .. ..@ dose.median     : num 136
  .. .. .. ..@ dose.mode       : num 6.9
  .. .. .. ..@ dose.STD        : num 953
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 98.5 95.9 93.8 90.8 ...
  .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ BODY        :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. ..@ patient		   : chr "Jane Doe"
  .. .. .. ..@ ID			   : chr "1111111111"
  .. .. .. ..@ structure.name  : chr "BODY"
  .. .. .. ..@ structure.volume: num 25508
  .. .. .. ..@ type            : chr "cumulative"
  .. .. .. ..@ dose.max        : num 5665
  .. .. .. ..@ dose.min        : num 0
  .. .. .. ..@ dose.mean       : num 478
  .. .. .. ..@ dose.median     : num 66.4
  .. .. .. ..@ dose.mode       : num 0.4
  .. .. .. ..@ dose.STD        : num 946
  .. .. .. ..@ conf.index      : num 0
  .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. ..@ gradient        : num 0
  .. .. .. ..@ dose.rx         : num 5500
  .. .. .. ..@ dose.fx         : num 25
  .. .. .. ..@ rx.isodose      : num 100
  .. .. .. ..@ doses           : num [1:1133] 0 5 10 15 20 25 30 35 40 45 ...
  .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. ..@ volumes         : num [1:1133] 100 77.7 75.1 73 71.3 ...
  .. .. .. ..@ volume.type     : chr "relative"
}

  The format for \code{janedoe.RTdata} is:
\preformatted{
Formal class 'RTdata' [package "RadOnc"] with 4 slots
  ..@ name      : chr "Jane Doe"
  ..@ CT        : logi[0 , 0 , 0 ] 
  ..@ dose      : num [1:74, 1:72, 1:51] 2.79 2.87 2.96 3.08 3.32 ...
  .. ..- attr(*, "dimnames")=List of 3
  .. .. ..$ : chr [1:74] "-57.5120192" "-55.0120192" "-52.5120192" "-50.0120192" ...
  .. .. ..$ : chr [1:72] "-309.3547858" "-306.8547858" "-304.3547858" "-301.8547858" ...
  .. .. ..$ : chr [1:51] "-102" "-99" "-96" "-93" ...
  ..@ structures:Formal class 'structure.list' [package "RadOnc"] with 1 slots
  .. .. ..@ structures:List of 3
  .. .. .. ..$ STOMACH:Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. .. .. ..@ name            : chr "STOMACH"
  .. .. .. .. .. ..@ volume          : num 0
  .. .. .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. .. .. ..@ vertices        : num [1:9222, 1:3] -23.4 -21.5 -19.5 -17.6 -15.6 ...
  .. .. .. .. .. ..@ origin          : num [1:3] 42.5 -202.6 -26.8
  .. .. .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. .. .. ..@ closed.polys    :List of 52
  .. .. .. .. .. .. ..$ : num [1:192, 1:3] -23.4 -21.5 -19.5 -17.6 -15.6 ...
  .. .. .. .. .. .. ..$ : num [1:188, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 7.81 ...
  .. .. .. .. .. .. ..$ : num [1:4, 1:3] 70.3 70.1 70.3 70.5 -191.9 ...
  .. .. .. .. .. .. ..$ : num [1:192, 1:3] -5.86 -3.91 -1.95 0 1.95 ...
  .. .. .. .. .. .. ..$ : num [1:182, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:180, 1:3] -35.2 -33.2 -31.2 -29.3 -27.3 ...
  .. .. .. .. .. .. ..$ : num [1:174, 1:3] -35.2 -33.2 -31.2 -29.3 -27.3 ...
  .. .. .. .. .. .. ..$ : num [1:180, 1:3] -33.2 -31.2 -29.3 -27.3 -25.4 ...
  .. .. .. .. .. .. ..$ : num [1:170, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:168, 1:3] -3.91 -1.95 0 1.95 3.91 ...
  .. .. .. .. .. .. ..$ : num [1:160, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:152, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:174, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 6.48 ...
  .. .. .. .. .. .. ..$ : num [1:176, 1:3] -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 7.81 9.77 ...
  .. .. .. .. .. .. ..$ : num [1:176, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:4, 1:3] 7.81 6.99 7.81 8.11 -158.68 ...
  .. .. .. .. .. .. ..$ : num [1:194, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:4, 1:3] -29.3 -29.3 -29.3 -29.3 -160.8 ...
  .. .. .. .. .. .. ..$ : num [1:194, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 7.81 ...
  .. .. .. .. .. .. ..$ : num [1:192, 1:3] -13.67 -11.72 -9.77 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:214, 1:3] -11.72 -9.77 -7.81 -5.86 -3.91 ...
  .. .. .. .. .. .. ..$ : num [1:216, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 4.51 5.86 ...
  .. .. .. .. .. .. ..$ : num [1:214, 1:3] -11.72 -9.77 -7.81 -5.86 -3.91 ...
  .. .. .. .. .. .. ..$ : num [1:204, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:208, 1:3] -5.86 -3.91 -1.95 0 1.95 3.81 3.91 5.86 7.81 9.77 ...
  .. .. .. .. .. .. ..$ : num [1:210, 1:3] 7.81 9.77 11.72 13.67 15.63 ...
  .. .. .. .. .. .. ..$ : num [1:4, 1:3] 7.81 7.71 7.81 7.91 -164.59 ...
  .. .. .. .. .. .. ..$ : num [1:208, 1:3] -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 7.81 9.77 ...
  .. .. .. .. .. .. ..$ : num [1:198, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 0 1.95 3.91 5.86 7.81 ...
  .. .. .. .. .. .. ..$ : num [1:198, 1:3] -1.95 0 1.95 3.91 5.57 ...
  .. .. .. .. .. .. ..$ : num [1:232, 1:3] 1.95 3.91 5.86 6.47 7.81 ...
  .. .. .. .. .. .. ..$ : num [1:236, 1:3] 7.81 9.77 11.72 13.67 15.63 ...
  .. .. .. .. .. .. ..$ : num [1:290, 1:3] 1.95 3.91 5.86 7.81 9.77 ...
  .. .. .. .. .. .. ..$ : num [1:278, 1:3] 21.5 23.4 25.4 27.3 28.5 ...
  .. .. .. .. .. .. ..$ : num [1:246, 1:3] 44.9 46.9 48.8 50.8 52.7 ...
  .. .. .. .. .. .. ..$ : num [1:248, 1:3] 44.9 46.9 48.8 50.8 52.7 ...
  .. .. .. .. .. .. ..$ : num [1:234, 1:3] 56.6 58.6 60.5 62.5 64.5 ...
  .. .. .. .. .. .. ..$ : num [1:234, 1:3] 62.5 64.5 66.4 68.4 70.3 ...
  .. .. .. .. .. .. ..$ : num [1:232, 1:3] 70.3 72.3 74.2 76.2 78.1 ...
  .. .. .. .. .. .. ..$ : num [1:216, 1:3] 78.1 80.1 82 84 85.9 ...
  .. .. .. .. .. .. ..$ : num [1:212, 1:3] 80.1 82 84 85.9 87.9 ...
  .. .. .. .. .. .. ..$ : num [1:202, 1:3] 80.1 82 84 85.9 86.4 ...
  .. .. .. .. .. .. ..$ : num [1:198, 1:3] 80.1 82 84 85.9 87.9 ...
  .. .. .. .. .. .. ..$ : num [1:180, 1:3] 87.9 89.5 89.8 91.8 93.8 ...
  .. .. .. .. .. .. ..$ : num [1:176, 1:3] 91.8 93.8 95.7 97.7 99.6 ...
  .. .. .. .. .. .. ..$ : num [1:158, 1:3] 84 85.9 87.9 89.8 90 ...
  .. .. .. .. .. .. ..$ : num [1:158, 1:3] 84 85.9 87.9 88.1 89.8 ...
  .. .. .. .. .. .. ..$ : num [1:142, 1:3] 80.1 82 84 85.9 87.9 ...
  .. .. .. .. .. .. ..$ : num [1:146, 1:3] 78.1 80.1 82 84 85.9 ...
  .. .. .. .. .. .. ..$ : num [1:130, 1:3] 76.2 78.1 80.1 82 84 ...
  .. .. .. .. .. .. ..$ : num [1:74, 1:3] 80.1 82 84 85.9 86.1 ...
  .. .. .. .. .. .. ..$ : num [1:70, 1:3] 82 84 85.9 87.3 87.9 ...
  .. .. .. .. .. .. ..- attr(*, "dim")= int [1:2] 52 1
  .. .. .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 22 slots
  .. .. .. .. .. .. .. ..@ patient         : chr ""
  .. .. .. .. .. .. .. ..@ ID              : chr ""
  .. .. .. .. .. .. .. ..@ structure.name  : chr "STOMACH"
  .. .. .. .. .. .. .. ..@ structure.volume: num 699
  .. .. .. .. .. .. .. ..@ type            : chr "differential"
  .. .. .. .. .. .. .. ..@ dose.max        : num 53.6
  .. .. .. .. .. .. .. ..@ dose.min        : num 0.594
  .. .. .. .. .. .. .. ..@ dose.mean       : num 12.8
  .. .. .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. .. .. ..@ dose.rx         : num 55
  .. .. .. .. .. .. .. ..@ dose.fx         : num 25
  .. .. .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. .. .. ..@ doses           : num [1:5665] 0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 ...
  .. .. .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. .. .. ..@ dose.units      : chr "Gy"
  .. .. .. .. .. .. .. ..@ volumes         : num [1:5665] 0 0 0 0 0 0 0 0 0 0 ...
  .. .. .. .. .. .. .. ..@ volume.type     : chr "absolute"
  .. .. .. ..$ CTV    :Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. .. .. ..@ name            : chr "CTV"
  .. .. .. .. .. ..@ volume          : num 0
  .. .. .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. .. .. ..@ vertices        : num [1:2440, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. ..@ origin          : num [1:3] -11.9 -237.5 -52.7
  .. .. .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. .. .. ..@ closed.polys    :List of 23
  .. .. .. .. .. .. ..$ : num [1:56, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:74, 1:3] -31.2 -29.3 -27.3 -25.4 -23.4 ...
  .. .. .. .. .. .. ..$ : num [1:92, 1:3] -27.3 -25.4 -23.4 -21.5 -19.5 ...
  .. .. .. .. .. .. ..$ : num [1:96, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:102, 1:3] -27.3 -25.4 -23.4 -21.5 -19.5 ...
  .. .. .. .. .. .. ..$ : num [1:112, 1:3] -23.4 -22.5 -21.5 -19.5 -17.6 ...
  .. .. .. .. .. .. ..$ : num [1:116, 1:3] -39.1 -37.1 -35.2 -33.2 -31.2 ...
  .. .. .. .. .. .. ..$ : num [1:112, 1:3] -35.2 -33.2 -31.2 -29.3 -27.3 ...
  .. .. .. .. .. .. ..$ : num [1:114, 1:3] -21.5 -19.5 -17.6 -15.6 -13.7 ...
  .. .. .. .. .. .. ..$ : num [1:110, 1:3] -21.5 -19.5 -17.6 -15.6 -13.7 ...
  .. .. .. .. .. .. ..$ : num [1:112, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:108, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:116, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:120, 1:3] -11.72 -9.77 -8.79 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:126, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:124, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:124, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:120, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:110, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:106, 1:3] -13.67 -11.72 -9.77 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:102, 1:3] -13.67 -11.72 -9.77 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:100, 1:3] -11.72 -9.77 -7.81 -5.86 -3.91 ...
  .. .. .. .. .. .. ..$ : num [1:88, 1:3] -11.72 -9.77 -7.81 -5.86 -3.91 ...
  .. .. .. .. .. .. ..- attr(*, "dim")= int [1:2] 23 1
  .. .. .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 22 slots
  .. .. .. .. .. .. .. ..@ patient         : chr ""
  .. .. .. .. .. .. .. ..@ ID              : chr ""
  .. .. .. .. .. .. .. ..@ structure.name  : chr "CTV"
  .. .. .. .. .. .. .. ..@ structure.volume: num 148
  .. .. .. .. .. .. .. ..@ type            : chr "differential"
  .. .. .. .. .. .. .. ..@ dose.max        : num 56.5
  .. .. .. .. .. .. .. ..@ dose.min        : num 51.7
  .. .. .. .. .. .. .. ..@ dose.mean       : num 55
  .. .. .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. .. .. ..@ dose.rx         : num 55
  .. .. .. .. .. .. .. ..@ dose.fx         : num 25
  .. .. .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. .. .. ..@ doses           : num [1:5665] 0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 ...
  .. .. .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. .. .. ..@ dose.units      : chr "Gy"
  .. .. .. .. .. .. .. ..@ volumes         : num [1:5665] 0 0 0 0 0 0 0 0 0 0 ...
  .. .. .. .. .. .. .. ..@ volume.type     : chr "absolute"
  .. .. .. ..$ PTV    :Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. .. .. ..@ name            : chr "PTV"
  .. .. .. .. .. ..@ volume          : num 0
  .. .. .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. .. .. ..@ vertices        : num [1:3314, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. ..@ origin          : num [1:3] -11.8 -237.1 -52.7
  .. .. .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. .. .. ..@ closed.polys    :List of 27
  .. .. .. .. .. .. ..$ : num [1:64, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:78, 1:3] -31.2 -29.3 -27.3 -25.4 -23.4 ...
  .. .. .. .. .. .. ..$ : num [1:94, 1:3] -33.2 -31.2 -29.3 -27.3 -25.4 ...
  .. .. .. .. .. .. ..$ : num [1:106, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:112, 1:3] -31.2 -29.3 -27.3 -25.4 -23.4 ...
  .. .. .. .. .. .. ..$ : num [1:126, 1:3] -33.2 -31.2 -29.3 -27.3 -25.4 ...
  .. .. .. .. .. .. ..$ : num [1:130, 1:3] -31.2 -29.3 -27.3 -25.4 -23.4 ...
  .. .. .. .. .. .. ..$ : num [1:136, 1:3] -29.3 -27.3 -25.4 -23.4 -21.5 ...
  .. .. .. .. .. .. ..$ : num [1:134, 1:3] -27.3 -25.4 -23.4 -21.5 -20.4 ...
  .. .. .. .. .. .. ..$ : num [1:136, 1:3] -41 -39.1 -37.1 -35.2 -33.2 ...
  .. .. .. .. .. .. ..$ : num [1:134, 1:3] -37.1 -35.2 -33.2 -31.2 -29.3 ...
  .. .. .. .. .. .. ..$ : num [1:132, 1:3] -23.4 -21.5 -19.5 -17.6 -15.6 ...
  .. .. .. .. .. .. ..$ : num [1:128, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:134, 1:3] -21.5 -19.5 -17.6 -15.6 -13.7 ...
  .. .. .. .. .. .. ..$ : num [1:138, 1:3] -13.67 -11.72 -9.77 -7.81 -6.71 ...
  .. .. .. .. .. .. ..$ : num [1:144, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:142, 1:3] -21.5 -19.5 -17.6 -15.6 -13.7 ...
  .. .. .. .. .. .. ..$ : num [1:144, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:142, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:140, 1:3] -21.5 -19.5 -17.6 -15.6 -13.7 ...
  .. .. .. .. .. .. ..$ : num [1:136, 1:3] -19.5 -17.6 -15.6 -13.7 -11.7 ...
  .. .. .. .. .. .. ..$ : num [1:130, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:122, 1:3] -17.58 -15.63 -13.67 -11.72 -9.77 ...
  .. .. .. .. .. .. ..$ : num [1:118, 1:3] -15.63 -13.67 -11.72 -9.77 -7.81 ...
  .. .. .. .. .. .. ..$ : num [1:116, 1:3] -13.67 -11.72 -9.77 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:104, 1:3] -13.67 -11.72 -9.77 -7.81 -5.86 ...
  .. .. .. .. .. .. ..$ : num [1:94, 1:3] -9.77 -7.81 -5.86 -3.91 -1.95 -0.6 0 1.95 3.91 5.14 ...
  .. .. .. .. .. .. ..- attr(*, "dim")= int [1:2] 27 1
  .. .. .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 22 slots
  .. .. .. .. .. .. .. ..@ patient         : chr ""
  .. .. .. .. .. .. .. ..@ ID              : chr ""
  .. .. .. .. .. .. .. ..@ structure.name  : chr "PTV"
  .. .. .. .. .. .. .. ..@ structure.volume: num 241
  .. .. .. .. .. .. .. ..@ type            : chr "differential"
  .. .. .. .. .. .. .. ..@ dose.max        : num 56.6
  .. .. .. .. .. .. .. ..@ dose.min        : num 47.1
  .. .. .. .. .. .. .. ..@ dose.mean       : num 54.7
  .. .. .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. .. .. ..@ dose.rx         : num 55
  .. .. .. .. .. .. .. ..@ dose.fx         : num 25
  .. .. .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. .. .. ..@ doses           : num [1:5665] 0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 ...
  .. .. .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. .. .. ..@ dose.units      : chr "Gy"
  .. .. .. .. .. .. .. ..@ volumes         : num [1:5665] 0 0 0 0 0 0 0 0 0 0 ...
  .. .. .. .. .. .. .. ..@ volume.type     : chr "absolute"
}

  The format for \code{cord} is:
\preformatted{
Formal class 'structure3D' [package "RadOnc"] with 9 slots
  ..@ name            : chr "Spinal Cord"
  ..@ volume          : num 0
  ..@ volume.units    : chr "cc"
  ..@ coordinate.units: chr "cm"
  ..@ vertices        : num [1:2682, 1:3] -10.74 -8.79 -6.84 -4.88 -3.13 ...
  .. ..- attr(*, "dimnames")=List of 2
  .. .. ..$ : chr [1:2682] "" "" "" "" ...
  .. .. ..$ : NULL
  ..@ origin          : num [1:3] -3.43 -235.27 -173.95
  ..@ triangles       : num [1:3, 1:5360] 20 1 21 1 2 22 2 3 23 3 ...
  ..@ closed.polys    :List of 130
  .. ..$ : num [1:20, 1:3] -10.74 -8.79 -6.84 -4.88 -3.13 ...
  .. ..$ : num [1:18, 1:3] -10.74 -8.79 -6.84 -4.88 -3.15 ...
  .. ..$ : num [1:20, 1:3] -6.84 -6.1 -4.88 -2.93 -2.62 -1.68 -1.77 -2.53 -2.93 -4.88 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.95 -4.88 -2.93 -2.16 -1.36 -1.41 -2.33 -2.93 -4.88 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -3.34 -2.93 -2.07 -1.72 -2.38 -2.93 -4.26 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -4.67 -2.93 -2.67 -2.12 -2.31 -2.93 -3.45 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -3.99 -2.93 -2.14 -1.77 -2.01 -2.93 -3.61 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -2.93 -2.91 -1.75 -1.55 -2.01 -2.93 -3.65 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -2.93 -2.62 -1.53 -1.4 -1.95 -2.93 -4.08 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -2.93 -2.51 -1.4 -1.37 -2.18 -2.93 -4.88 ...
  .. ..$ : num [1:18, 1:3] -8.79 -6.84 -4.88 -2.93 -1.77 -1.28 -1.89 -2.93 -3.54 -4.88 ...
  .. ..$ : num [1:16, 1:3] -6.84 -4.88 -2.99 -2.93 -1.06 -1.34 -2.51 -2.93 -4.88 -6.84 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -2.21 -0.98 -0.67 -0.8 -0.98 -2.01 -2.93 ...
  .. ..$ : num [1:18, 1:3] -8.79 -6.84 -4.88 -2.93 -1.37 -0.98 -0.54 -0.56 -0.98 -1.49 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -2.93 -1.43 -0.98 -0.34 -0.38 -0.98 -1.61 ...
  .. ..$ : num [1:18, 1:3] -8.79 -6.84 -4.88 -2.93 -1.36 -0.98 -0.55 -0.56 -0.98 -1.49 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.87 -1.03 -0.98 -0.23 -0.46 -0.98 -1.89 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.26 -0.98 -0.64 -0.23 -0.55 -0.98 -2.03 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.34 -0.98 -0.57 -0.18 -0.57 -0.98 -2.44 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.26 -0.98 -0.67 -0.27 -0.92 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.18 -0.98 -0.79 -0.49 -0.98 -1.12 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -3.66 -2.93 -1.04 -0.98 -0.18 -0.16 -0.98 -1.46 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.51 -0.98 -0.06 0.28 -0.14 -0.98 -1.75 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.92 0.31 0.18 -0.92 -0.98 -2.93 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.46 0.44 -0.09 -0.98 -2.93 -4.83 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.92 0.34 0.31 -0.98 -1.95 -2.93 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -1.64 -0.98 0.07 0.56 -0.69 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.83 -0.98 -0.46 0.43 0.34 -0.98 -1.07 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.03 -0.98 0.26 0.55 -0.02 -0.98 -1.5 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.25 -0.98 -0.31 0.46 0.23 -0.92 -0.98 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.62 0.4 0.51 -0.2 -0.98 -2.61 ...
  .. ..$ : num [1:22, 1:3] -4.88 -2.93 -2.83 -0.98 -0.23 0.55 0.55 -0.18 -0.98 -2.83 ...
  .. ..$ : num [1:22, 1:3] -4.88 -2.93 -2.2 -0.98 -0.08 0.53 0.49 -0.33 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.65 -0.98 0.11 0.43 0.23 -0.98 -1.07 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.21 -0.98 0.02 0.27 -0.27 -0.98 -2.15 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.81 -0.98 -0.06 0.92 0.67 -0.34 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 -0.58 0.95 0.98 1.37 0.98 0.98 -0.54 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.79 0.49 0.8 0.18 -0.98 -2.05 ...
  .. ..$ : num [1:20, 1:3] -8.79 -6.84 -4.88 -2.93 -1.09 -0.98 -0.11 -0.03 -0.76 -0.98 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.25 -0.98 -0.18 0.46 -0.06 -0.98 -1.86 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.6 0.58 0.8 -0.3 -0.98 -2.93 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.16 0.92 0.92 -0.13 -0.98 -2.93 ...
  .. ..$ : num [1:22, 1:3] -4.88 -2.93 -2.29 -0.98 0.32 0.98 1.07 0.98 0.94 -0.05 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.07 -0.98 0.34 0.92 0.34 -0.98 -1.56 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.5 0.43 0.49 -0.3 -0.98 -2.93 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.18 0.79 0.8 -0.34 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 0.03 0.97 0.98 1.06 0.98 -0.4 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.34 -0.98 0.31 0.79 0.43 -0.98 -2.34 ...
  .. ..$ : num [1:18, 1:3] -6.84 -4.88 -2.93 -0.98 -0.57 0.41 0.5 -0.29 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.1 -0.98 -0.46 0 -0.55 -0.98 -2.49 ...
  .. ..$ : num [1:22, 1:3] -6.84 -4.88 -3.95 -2.93 -1.28 -0.98 -0.54 -0.59 -0.98 -1.59 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -3.09 -2.93 -1.03 -0.98 -0.23 -0.46 -0.98 -1.89 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.47 -0.98 -0.72 -0.24 -0.51 -0.98 -1.92 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.08 -0.98 -0.23 0.06 -0.16 -0.98 -1.88 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.59 -0.98 -0.08 0.31 -0.11 -0.98 -1.68 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -2.7 -0.98 -0.69 0.06 -0.06 -0.98 -1.17 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.33 -0.98 -0.2 0 -0.57 -0.98 -2.64 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.85 -0.98 -0.55 0.34 0.23 -0.79 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.59 -0.98 0.09 0.56 0.23 -0.98 -1.14 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.67 0.43 0.55 -0.11 -0.98 -2.31 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.3 -0.98 -0.1 0.52 0.34 -0.77 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.24 -0.98 0.18 0.43 -0.11 -0.98 -2.05 ...
  .. ..$ : num [1:20, 1:3] -4.88 -3.48 -2.93 -0.98 -0.56 0.23 0.18 -0.73 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.66 -0.98 -0.11 0.55 0.46 -0.55 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.24 -0.98 0.11 0.78 0.63 -0.43 -0.98 -2.93 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.38 -0.98 0.34 0.67 0.18 -0.98 -1.3 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.3 -0.98 0.18 0.67 0.34 -0.98 -1.38 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.41 0.64 0.78 0.1 -0.98 -2.27 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -1.27 -0.98 0.06 0.55 0.06 -0.98 -1.27 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -2.49 -0.98 -0.17 0.52 0.38 -0.68 -0.98 -2.93 ...
  .. ..$ : num [1:22, 1:3] -6.84 -4.88 -2.93 -0.98 -0.92 0.67 0.98 1.04 0.98 0.55 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 0.22 0.98 1.27 1.33 0.98 0.63 ...
  .. ..$ : num [1:22, 1:3] -4.88 -2.93 -2.12 -0.98 0.34 0.98 1.38 1.26 0.98 0.11 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.23 0.98 1.15 1.49 0.98 0.69 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 0.37 0.98 1.31 1.32 0.98 0.51 ...
  .. ..$ : num [1:20, 1:3] -6.84 -4.88 -2.93 -0.98 -0.34 0.92 0.98 1.26 0.98 0.46 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 -0.69 0.92 0.98 1.36 1.03 0.98 -0.43 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 -0.35 0.98 1.4 1.9 1.53 0.98 -0.13 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.08 0.98 1.7 2.16 1.82 0.98 0.39 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0 0.98 1.53 2.3 2.01 0.98 0.9 ...
  .. ..$ : num [1:20, 1:3] -2.93 -0.98 0 0.98 2.26 2.91 2.75 1.66 0.98 -0.98 ...
  .. ..$ : num [1:18, 1:3] -4.88 -2.93 -0.98 0.98 1.16 2.38 2.62 1.89 0.98 -0.12 ...
  .. ..$ : num [1:18, 1:3] -4.88 -2.93 -0.98 -0.17 0.98 1.82 2.39 2.16 1 0.98 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.57 0.98 2.07 2.38 1.77 0.98 0.1 ...
  .. ..$ : num [1:20, 1:3] -2.93 -0.98 0.08 0.98 1.9 2.38 2.07 0.98 0.57 -0.98 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.91 0.98 2.14 2.4 1.86 0.98 -0.11 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.98 1.16 2.3 2.38 1.61 0.98 -0.71 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0 0.98 1.79 2.26 1.95 0.98 0.45 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.52 0.98 1.85 2.15 1.66 0.98 -0.07 ...
  .. ..$ : num [1:22, 1:3] -2.93 -2.44 -0.98 0.98 1.28 2.33 2.26 1.4 0.98 -0.73 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.98 1.88 2.93 2.99 3.22 2.93 2.26 ...
  .. ..$ : num [1:22, 1:3] -2.93 -0.98 -0.02 0.98 2.7 2.93 3.43 3.38 2.93 2.4 ...
  .. ..$ : num [1:20, 1:3] -2.93 -0.98 0.84 0.98 2.87 2.93 3.63 3.33 2.93 1.89 ...
  .. ..$ : num [1:20, 1:3] -2.93 -0.98 0.98 1.88 2.93 3.45 3.56 2.93 2.62 0.98 ...
  .. ..$ : num [1:18, 1:3] -4.88 -2.93 -0.98 0.98 2.41 2.93 3.44 3.4 2.93 2.47 ...
  .. ..$ : num [1:20, 1:3] -4.88 -2.93 -0.98 0.98 2.34 2.93 3.63 3.56 2.93 2.38 ...
  .. ..$ : num [1:22, 1:3] -0.98 -0.37 0.98 2.5 2.93 3.63 3.56 2.93 2.38 0.98 ...
  .. ..$ : num [1:20, 1:3] -0.98 -0.37 0.98 2.64 2.93 3.43 3.4 2.93 2.47 0.98 ...
  .. ..$ : num [1:20, 1:3] -2.93 -0.98 0.37 0.98 2.75 2.93 3.56 3.33 2.93 2.01 ...
  .. .. [list output truncated]
  .. ..- attr(*, "dim")= int [1:2] 130 1
  ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. ..@ patient		    : chr ""
  .. .. ..@ ID			    : chr ""
  .. .. ..@ structure.name  : chr ""
  .. .. ..@ structure.volume: num 0
  .. .. ..@ type            : chr "cumulative"
  .. .. ..@ dose.max        : num 0
  .. .. ..@ dose.min        : num 0
  .. .. ..@ dose.mean       : num 0
  .. .. ..@ dose.median     : num 0
  .. .. ..@ dose.mode       : num 0
  .. .. ..@ dose.STD        : num 0
  .. .. ..@ conf.index      : num 0
  .. .. ..@ equiv.sphere    : num 0
  .. .. ..@ gradient        : num 0
  .. .. ..@ dose.rx         : num 0
  .. .. ..@ dose.fx         : num 0
  .. .. ..@ rx.isodose      : num 100
  .. .. ..@ doses           : num(0) 
  .. .. ..@ dose.type       : chr "absolute"
  .. .. ..@ dose.units      : chr "cGy"
  .. .. ..@ volumes         : num(0) 
  .. .. ..@ volume.type     : chr "relative"
}

  The format for \code{mandible} is:
\preformatted{
Formal class 'structure3D' [package "RadOnc"] with 9 slots
  ..@ name            : chr "Mandible"
  ..@ volume          : num 0
  ..@ volume.units    : chr "cc"
  ..@ coordinate.units: chr "cm"
  ..@ vertices        : num [1:6994, 1:3] -12.7 -10.74 -8.79 -6.84 -4.88 ...
  .. ..- attr(*, "dimnames")=List of 2
  .. .. ..$ : chr [1:6994] "" "" "" "" ...
  .. .. ..$ : NULL
  ..@ origin          : num [1:3] -1.93 -151.83 -122.85
  ..@ triangles       : num [1:3, 1:13984] 46 47 49 48 1 50 1 2 51 2 ...
  ..@ closed.polys    :List of 104
  .. ..$ : num [1:48, 1:3] -12.7 -10.74 -8.79 -6.84 -4.88 ...
  .. ..$ : num [1:52, 1:3] -14.65 -12.7 -10.74 -8.79 -6.84 ...
  .. ..$ : num [1:68, 1:3] -14.65 -12.7 -10.74 -8.79 -6.84 ...
  .. ..$ : num [1:74, 1:3] -14.65 -12.7 -10.74 -8.79 -6.84 ...
  .. ..$ : num [1:80, 1:3] -6.84 -6.51 -4.88 -2.93 -0.98 0.98 1.17 2.93 4.88 6.08 ...
  .. ..$ : num [1:90, 1:3] -10.74 -8.79 -6.84 -4.88 -2.93 ...
  .. ..$ : num [1:94, 1:3] -10.74 -8.79 -6.84 -4.88 -2.93 ...
  .. ..$ : num [1:98, 1:3] -10.74 -8.79 -6.84 -4.88 -2.93 ...
  .. ..$ : num [1:110, 1:3] -8.79 -6.84 -5.62 -4.88 -2.93 -0.98 0.98 1.27 2.93 4.77 ...
  .. ..$ : num [1:118, 1:3] -8.79 -6.84 -5.09 -4.88 -2.93 -0.98 0.98 1.52 2.93 4.88 ...
  .. ..$ : num [1:124, 1:3] -8.79 -6.84 -4.88 -2.93 -0.98 -0.61 0.98 2.93 3.35 4.88 ...
  .. ..$ : num [1:136, 1:3] -8.79 -6.84 -4.88 -2.93 -0.98 0.94 0.98 2.93 4.88 5.94 ...
  .. ..$ : num [1:140, 1:3] -12.7 -10.74 -8.79 -6.84 -4.88 ...
  .. ..$ : num [1:150, 1:3] -8.79 -6.84 -4.88 -2.93 -2.66 -0.98 0.98 2.93 4.88 5.28 ...
  .. ..$ : num [1:154, 1:3] -12.7 -10.74 -8.79 -6.84 -4.88 ...
  .. ..$ : num [1:172, 1:3] -10.74 -8.79 -6.84 -4.88 -2.93 ...
  .. ..$ : num [1:178, 1:3] -14.65 -12.7 -10.74 -8.79 -6.84 ...
  .. ..$ : num [1:184, 1:3] -8.79 -6.84 -4.88 -2.93 -1.95 -0.98 0.98 2.93 4.88 6.84 ...
  .. ..$ : num [1:202, 1:3] -8.79 -6.84 -4.88 -2.93 -1.46 -0.98 0.98 2.93 4.88 6.84 ...
  .. ..$ : num [1:210, 1:3] -8.79 -6.84 -4.88 -2.93 -0.98 0.9 0.98 2.93 4.88 6.84 ...
  .. ..$ : num [1:108, 1:3] -0.98 0.98 1.95 2.93 3.91 4.88 6.84 6.98 8.79 9.94 ...
  .. ..$ : num [1:94, 1:3] -20.5 -18.6 -16.6 -14.7 -12.7 ...
  .. ..$ : num [1:94, 1:3] 12.7 14.7 15.5 16.6 17.3 ...
  .. ..$ : num [1:84, 1:3] -26.4 -24.4 -22.5 -20.9 -20.5 ...
  .. ..$ : num [1:94, 1:3] 14.7 15.3 16.6 17.4 18.6 ...
  .. ..$ : num [1:86, 1:3] -26.4 -24.4 -22.7 -22.5 -20.5 ...
  .. ..$ : num [1:90, 1:3] 12.7 14.7 16.6 18.3 18.6 ...
  .. ..$ : num [1:82, 1:3] -26.4 -24.4 -22.5 -22 -20.5 ...
  .. ..$ : num [1:80, 1:3] 22.5 24.4 24.8 26.4 26.9 ...
  .. ..$ : num [1:76, 1:3] -30.3 -28.3 -26.4 -24.4 -22.5 ...
  .. ..$ : num [1:78, 1:3] 20.5 22.5 24.4 26.1 26.4 ...
  .. ..$ : num [1:74, 1:3] -32.2 -30.3 -28.3 -26.4 -24.4 ...
  .. ..$ : num [1:74, 1:3] -32.2 -30.3 -28.3 -26.4 -24.4 ...
  .. ..$ : num [1:76, 1:3] 20.5 22.5 24.4 26.4 27.2 ...
  .. ..$ : num [1:72, 1:3] -32.2 -30.3 -28.3 -26.4 -24.6 ...
  .. ..$ : num [1:72, 1:3] 22.5 24.4 26.4 28.3 30.3 ...
  .. ..$ : num [1:72, 1:3] -32.2 -30.3 -28.3 -26.4 -25.6 ...
  .. ..$ : num [1:70, 1:3] 22.5 24.4 26.4 28.3 30.3 ...
  .. ..$ : num [1:68, 1:3] -36.1 -34.2 -32.2 -30.3 -28.3 ...
  .. ..$ : num [1:70, 1:3] 24.4 26.4 28.3 30.3 32.2 ...
  .. ..$ : num [1:70, 1:3] 30.3 32.2 34.2 36.1 38.1 ...
  .. ..$ : num [1:68, 1:3] -38.1 -36.1 -34.2 -32.8 -32.2 ...
  .. ..$ : num [1:66, 1:3] 34.2 36.1 37.7 38.1 39.3 ...
  .. ..$ : num [1:64, 1:3] -42 -40 -38.1 -36.1 -34.2 ...
  .. ..$ : num [1:66, 1:3] 36.1 36.8 38.1 38.7 39.8 ...
  .. ..$ : num [1:62, 1:3] -44 -42 -40 -38.1 -36.1 ...
  .. ..$ : num [1:64, 1:3] 36.1 36.8 38.1 39.2 40 ...
  .. ..$ : num [1:60, 1:3] -40 -38.1 -36.1 -34.7 -34.2 ...
  .. ..$ : num [1:62, 1:3] 36.1 36.6 38.1 39.5 40 ...
  .. ..$ : num [1:56, 1:3] -42 -40 -38.1 -36.1 -34.2 ...
  .. ..$ : num [1:62, 1:3] 36.1 36.3 38.1 39.3 40 ...
  .. ..$ : num [1:56, 1:3] -42 -40 -38.1 -36.1 -34.2 ...
  .. ..$ : num [1:60, 1:3] 34.2 36.1 38.1 39 40 ...
  .. ..$ : num [1:58, 1:3] -44 -42 -40 -38.7 -38.1 ...
  .. ..$ : num [1:58, 1:3] 34.2 36.1 38.1 38.8 40 ...
  .. ..$ : num [1:58, 1:3] -44 -42 -40 -39.4 -38.1 ...
  .. ..$ : num [1:58, 1:3] 34.2 36.1 38.1 39.2 40 ...
  .. ..$ : num [1:58, 1:3] -44 -42 -40 -39.4 -38.1 ...
  .. ..$ : num [1:56, 1:3] 36.1 38.1 38.9 40 40.3 ...
  .. ..$ : num [1:54, 1:3] -42 -41.9 -40 -39.6 -38.1 ...
  .. ..$ : num [1:56, 1:3] 36.1 38.1 39.6 40 40.6 ...
  .. ..$ : num [1:58, 1:3] -44 -42 -41.8 -40 -39.7 ...
  .. ..$ : num [1:56, 1:3] 36.1 38.1 39.7 40 40.9 ...
  .. ..$ : num [1:54, 1:3] -44 -42 -41.4 -40 -39.5 ...
  .. ..$ : num [1:58, 1:3] 36.1 38.1 38.9 40 40.3 ...
  .. ..$ : num [1:54, 1:3] -44 -42 -40.9 -40 -39.3 ...
  .. ..$ : num [1:58, 1:3] 36.1 38.1 39.3 40 40.4 ...
  .. ..$ : num [1:50, 1:3] -44 -42 -40.6 -40 -39.5 ...
  .. ..$ : num [1:54, 1:3] 36.1 38.1 39.5 40 41 ...
  .. ..$ : num [1:52, 1:3] -45.9 -44 -42 -40.1 -40 ...
  .. ..$ : num [1:52, 1:3] 38.1 39.9 40 41.4 41.9 ...
  .. ..$ : num [1:52, 1:3] -45.9 -44.8 -44 -42 -40 ...
  .. ..$ : num [1:54, 1:3] 38.1 38.4 40 40.6 41.7 ...
  .. ..$ : num [1:52, 1:3] -45.9 -44 -42 -41.9 -40.1 ...
  .. ..$ : num [1:54, 1:3] 38.1 39.9 40 41 41.8 ...
  .. ..$ : num [1:48, 1:3] -45.9 -44 -42.2 -42 -40.8 ...
  .. ..$ : num [1:52, 1:3] 38.1 40 40.7 41.6 42 ...
  .. ..$ : num [1:48, 1:3] -45.9 -44 -42.4 -42 -41.5 ...
  .. ..$ : num [1:54, 1:3] 38.1 39.1 40 41.3 42 ...
  .. ..$ : num [1:48, 1:3] -45.9 -44.1 -44 -42.6 -42.6 ...
  .. ..$ : num [1:54, 1:3] 38.1 40 40.5 41.8 42 ...
  .. ..$ : num [1:48, 1:3] -45.9 -44 -43.4 -42.7 -42.6 ...
  .. ..$ : num [1:54, 1:3] 38.1 40 41.3 42 42.1 ...
  .. ..$ : num [1:52, 1:3] -45.9 -44.2 -44 -43.1 -43.1 ...
  .. ..$ : num [1:22, 1:3] 40 40.2 41.9 42 43 ...
  .. ..$ : num [1:22, 1:3] -45.9 -44 -43.6 -43 -43.1 ...
  .. ..$ : num [1:24, 1:3] 45.9 47.5 47.8 47.9 49.2 ...
  .. ..$ : num [1:24, 1:3] -49.8 -47.9 -47.4 -46.8 -46.7 ...
  .. ..$ : num [1:16, 1:3] 40 40.8 42 42.4 43.2 ...
  .. ..$ : num [1:22, 1:3] -45.9 -45.5 -44 -43.8 -43.5 ...
  .. ..$ : num [1:26, 1:3] 45.9 46.4 47.9 48.1 49.3 ...
  .. ..$ : num [1:22, 1:3] -49.8 -47.9 -47.8 -46.8 -46.2 ...
  .. ..$ : num [1:12, 1:3] 40 41.7 42 42.6 43.2 ...
  .. ..$ : num [1:18, 1:3] -47.9 -45.9 -44.5 -44 -44.1 ...
  .. ..$ : num [1:24, 1:3] 45.9 47.9 48.2 49.4 49.8 ...
  .. ..$ : num [1:22, 1:3] -49.8 -49.5 -47.9 -47.1 -46.2 ...
  .. ..$ : num [1:12, 1:3] 40 41.3 42 43 43.4 ...
  .. ..$ : num [1:18, 1:3] -47.9 -45.9 -44.9 -44.5 -44.5 ...
  .. ..$ : num [1:24, 1:3] 47.9 48.5 49.6 49.8 50.8 ...
  .. .. [list output truncated]
  .. ..- attr(*, "dim")= int [1:2] 104 1
  ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. ..@ patient		    : chr ""
  .. .. ..@ ID			    : chr ""
  .. .. ..@ structure.name  : chr ""
  .. .. ..@ structure.volume: num 0
  .. .. ..@ type            : chr "cumulative"
  .. .. ..@ dose.max        : num 0
  .. .. ..@ dose.min        : num 0
  .. .. ..@ dose.mean       : num 0
  .. .. ..@ dose.median     : num 0
  .. .. ..@ dose.mode       : num 0
  .. .. ..@ dose.STD        : num 0
  .. .. ..@ conf.index      : num 0
  .. .. ..@ equiv.sphere    : num 0
  .. .. ..@ gradient        : num 0
  .. .. ..@ dose.rx         : num 0
  .. .. ..@ dose.fx         : num 0
  .. .. ..@ rx.isodose      : num 100
  .. .. ..@ doses           : num(0) 
  .. .. ..@ dose.type       : chr "absolute"
  .. .. ..@ dose.units      : chr "cGy"
  .. .. ..@ volumes         : num(0) 
  .. .. ..@ volume.type     : chr "relative"
}

  The format for \code{teeth} is:
\preformatted{
Formal class 'structure.list' [package "RadOnc"] with 1 slots
  ..@ structures:List of 3
  .. ..$ Tooth #1:Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. ..@ name            : chr "Tooth #1"
  .. .. .. ..@ volume          : num 0
  .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. ..@ vertices        : num [1:324, 1:3] -28.3 -26.4 -24.4 -23.4 -22.5 ...
  .. .. .. ..@ origin          : num [1:3] -25.2 -129.3 -100.7
  .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. ..@ closed.polys    :List of 23
  .. .. .. .. ..$ : num [1:14, 1:3] -28.3 -26.4 -24.4 -23.4 -22.5 ...
  .. .. .. .. ..$ : num [1:20, 1:3] -28.3 -26.4 -25.8 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -30.3 -28.3 -26.4 -24.4 -24.1 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -30.3 -28.3 -26.4 -24.4 -24.4 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -30.3 -28.3 -26.4 -24.4 -23.4 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -27.5 -26.4 -24.4 -23.1 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -26.2 -24.4 -22.8 ...
  .. .. .. .. ..$ : num [1:20, 1:3] -28.3 -26.4 -25.3 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:30, 1:3] -28.3 -27.9 -26.4 -24.4 -24.1 ...
  .. .. .. .. ..$ : num [1:12, 1:3] -28.3 -26.6 -26.4 -24.4 -24 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -30.3 -28.3 -26.9 -26.4 -25 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -22.5 -20.5 -18.6 -17.9 -18.1 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -28.3 -28.2 -26.4 -24.4 -23.9 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -30.3 -28.3 -26.4 -25.6 -25.3 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -20.5 -18.6 -17 -17.6 -18.6 ...
  .. .. .. .. ..$ : num [1:16, 1:3] -28.3 -26.4 -25 -24.5 -26.3 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -20.5 -18.6 -17.4 -18.1 -18.6 ...
  .. .. .. .. ..$ : num [1:14, 1:3] -28.3 -26.4 -25.1 -26.3 -26.4 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -18.6 -17.3 -18.3 -18.6 -20.4 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -28.3 -27.4 -28.3 -30.3 ...
  .. .. .. .. ..$ : num [1:4, 1:3] -18.6 -17.3 -18.6 -19.7 -128.7 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -28.3 -27.5 -28.3 -30.3 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -18.6 -17.4 -16.8 -18.6 -20.4 ...
  .. .. .. .. ..- attr(*, "dim")= int [1:2] 23 1
  .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. .. .. ..@ patient	     : chr ""
  .. .. .. .. .. ..@ ID			     : chr ""
  .. .. .. .. .. ..@ structure.name  : chr ""
  .. .. .. .. .. ..@ structure.volume: num(0) 
  .. .. .. .. .. ..@ type            : chr "cumulative"
  .. .. .. .. .. ..@ dose.max        : num 0
  .. .. .. .. .. ..@ dose.min        : num 0
  .. .. .. .. .. ..@ dose.mean       : num 0
  .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. ..@ dose.rx         : num 0
  .. .. .. .. .. ..@ dose.fx         : num 0
  .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. ..@ doses           : num(0) 
  .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. .. .. ..@ volumes         : num(0) 
  .. .. .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ Tooth #2:Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. ..@ name            : chr "Tooth #2"
  .. .. .. ..@ volume          : num 0
  .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. ..@ vertices        : num [1:338, 1:3] -26.4 -26.2 -24.4 -23.5 -22.5 ...
  .. .. .. ..@ origin          : num [1:3] -25.1 -129.4 -100.9
  .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. ..@ closed.polys    :List of 24
  .. .. .. .. ..$ : num [1:16, 1:3] -26.4 -26.2 -24.4 -23.5 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -25.8 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -30.3 -28.3 -26.4 -24.5 -24.4 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.4 -23.9 -22.5 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -30.3 -28.3 -26.4 -24.4 -22.8 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -27.1 -26.4 -24.4 -23.2 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -26.4 -25.9 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -30.3 -28.3 -26.4 -25 -24.4 ...
  .. .. .. .. ..$ : num [1:18, 1:3] -28.3 -26.4 -24.7 -24.4 -22.8 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -22.5 -20.5 -18.6 -17.8 -18.6 ...
  .. .. .. .. ..$ : num [1:14, 1:3] -28.3 -26.4 -26.3 -24.6 -24.4 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -30.3 -28.3 -26.6 -26.4 -25.7 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -22.5 -20.5 -18.6 -17.9 -18.3 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -27.5 -26.4 -24.6 -24.4 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -20.5 -18.6 -16.9 -16.8 -18.6 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -28.3 -26.4 -24.4 -24.2 -24.3 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -30.3 -28.3 -27 -26.4 -28.3 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -20.5 -18.6 -16.6 -16.3 -16.4 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -28.3 -26.4 -25.3 -26.4 -28.3 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -28.3 -27.1 -28.3 -30.3 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -18.6 -17.1 -17.6 -18.6 -18.6 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -28.3 -26.9 -28.3 -30.3 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -18.6 -18.5 -16.6 -16.4 -16.6 ...
  .. .. .. .. ..$ : num [1:4, 1:3] -18.6 -16.8 -18.6 -19.1 -129.4 ...
  .. .. .. .. ..- attr(*, "dim")= int [1:2] 24 1
  .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. .. .. ..@ patient	     : chr ""
  .. .. .. .. .. ..@ ID			     : chr ""
  .. .. .. .. .. ..@ structure.name  : chr ""
  .. .. .. .. .. ..@ structure.volume: num(0) 
  .. .. .. .. .. ..@ type            : chr "cumulative"
  .. .. .. .. .. ..@ dose.max        : num 0
  .. .. .. .. .. ..@ dose.min        : num 0
  .. .. .. .. .. ..@ dose.mean       : num 0
  .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. ..@ dose.rx         : num 0
  .. .. .. .. .. ..@ dose.fx         : num 0
  .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. ..@ doses           : num(0) 
  .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. .. .. ..@ volumes         : num(0) 
  .. .. .. .. .. ..@ volume.type     : chr "relative"
  .. ..$ Tooth #3:Formal class 'structure3D' [package "RadOnc"] with 9 slots
  .. .. .. ..@ name            : chr "Tooth #3"
  .. .. .. ..@ volume          : num 0
  .. .. .. ..@ volume.units    : chr "cc"
  .. .. .. ..@ coordinate.units: chr "cm"
  .. .. .. ..@ vertices        : num [1:310, 1:3] -28.3 -26.4 -28.3 -29.4 -24.4 ...
  .. .. .. ..@ origin          : num [1:3] -24.7 -129.4 -100.3
  .. .. .. ..@ triangles       : logi[1:3, 0 ] 
  .. .. .. ..@ closed.polys    :List of 24
  .. .. .. .. ..$ : num [1:4, 1:3] -28.3 -26.4 -28.3 -29.4 -126.7 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -24.4 -22.5 -22 -22.5 -24.4 ...
  .. .. .. .. ..$ : num [1:16, 1:3] -28.3 -26.4 -24.4 -24 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.4 -24.1 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.4 -23.6 -22.5 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -26.4 -24.4 -23.4 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.4 -23 -22.5 ...
  .. .. .. .. ..$ : num [1:24, 1:3] -28.3 -26.4 -25.2 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.7 -24.4 -22.5 ...
  .. .. .. .. ..$ : num [1:22, 1:3] -28.3 -26.4 -24.4 -24.2 -22.9 ...
  .. .. .. .. ..$ : num [1:14, 1:3] -28.3 -26.4 -24.4 -23.6 -24 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -22.5 -20.5 -18.6 -16.8 -17.6 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -28.3 -26.4 -24.4 -23.5 -24.4 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -28.3 -26.4 -26 -25.4 -26.4 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -20.5 -18.6 -16.6 -16.5 -16.6 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -28.3 -27.3 -26.4 -24.4 -24.2 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -30.3 -28.3 -26.4 -26.3 -26.4 ...
  .. .. .. .. ..$ : num [1:10, 1:3] -20.5 -18.6 -16.6 -16.5 -16.6 ...
  .. .. .. .. ..$ : num [1:16, 1:3] -28.3 -27.3 -26.4 -25.4 -26.4 ...
  .. .. .. .. ..$ : num [1:8, 1:3] -20.5 -18.6 -16.7 -17.7 -18.6 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -28.3 -27.2 -28.3 -30.3 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -18.6 -18 -17.6 -18.6 -20.1 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -30.3 -29.7 -28.7 -30.3 -30.6 ...
  .. .. .. .. ..$ : num [1:6, 1:3] -18.6 -16.7 -16.7 -18.6 -18.7 ...
  .. .. .. .. ..- attr(*, "dim")= int [1:2] 24 1
  .. .. .. ..@ DVH             :Formal class 'DVH' [package "RadOnc"] with 18 slots
  .. .. .. .. .. ..@ patient	     : chr ""
  .. .. .. .. .. ..@ ID			     : chr ""
  .. .. .. .. .. ..@ structure.name  : chr ""
  .. .. .. .. .. ..@ structure.volume: num(0) 
  .. .. .. .. .. ..@ type            : chr "cumulative"
  .. .. .. .. .. ..@ dose.max        : num 0
  .. .. .. .. .. ..@ dose.min        : num 0
  .. .. .. .. .. ..@ dose.mean       : num 0
  .. .. .. .. .. ..@ dose.median     : num 0
  .. .. .. .. .. ..@ dose.mode       : num 0
  .. .. .. .. .. ..@ dose.STD        : num 0
  .. .. .. .. .. ..@ conf.index      : num 0
  .. .. .. .. .. ..@ equiv.sphere    : num 0
  .. .. .. .. .. ..@ gradient        : num 0
  .. .. .. .. .. ..@ dose.rx         : num 0
  .. .. .. .. .. ..@ dose.fx         : num 0
  .. .. .. .. .. ..@ rx.isodose      : num 100
  .. .. .. .. .. ..@ doses           : num(0) 
  .. .. .. .. .. ..@ dose.type       : chr "absolute"
  .. .. .. .. .. ..@ dose.units      : chr "cGy"
  .. .. .. .. .. ..@ volumes         : num(0) 
  .. .. .. .. .. ..@ volume.type     : chr "relative"
}
}

\examples{
data(list="RadOnc",package="RadOnc")
}
\keyword{datasets}
