#' A Dummy Data for Contour Plots
#'
#' @format
#' A data frame with 10000 observations on the following 3 variables.
#'   \describe{
#'     \item{\code{x}}{a x-axis variable}
#'     \item{\code{y}}{a y-axis variable}
#'     \item{\code{z}}{density}
#'   }
#' @examples
#' # This data is generated by the code below:
#' # set.seed(5435678)
#' # dataContour <- data.frame(
#' #   x = (zx <- (rep(1:100, 100) - 5) / 2),
#' #   y = (zy <- (rep(1:100, each=100) - 5) / 2),
#' #   z = (z  <- zx*zy)
#' # )
#' # save(dataContour, file = "dataContour.RData")
#'
#' try(data(dataContour, package = "RcmdrPlugin.KMggplot2"))
#' try(activeDataSet("dataContour"))
#' @seealso contour-class
#'
#' @name dataContour
#' @rdname data-dataContour
#' @docType data
#' @keywords data
NULL



#' A Dummy Data for Survival Analysis
#'
#' @format
#' A data frame with 200 observations on the following 8 variables.
#'   \describe{
#'     \item{\code{time}}{time from entry (months)}
#'     \item{\code{age}}{age}
#'     \item{\code{height}}{height}
#'     \item{\code{weight}}{weight}
#'     \item{\code{event}}{event variable (0: censor, 1: event)}
#'     \item{\code{trt}}{treatment group (has three groups "Group-A", "Group-B", and "Group-C")}
#'     \item{\code{marker}}{a biomarker level (has two groups "High", and "Low")}
#'     \item{\code{sex}}{sex}
#'   }
#' @examples
#' # This data is generated by the code below:
#' # set.seed(5435678)
#' # age <- round(rnorm(200, 65, 10))
#' # height <- rep(c(170, 160), each = 50) + rnorm(200, 0, 6)
#' # weight <- rep(c(50, 45.5), each = 50) + 0.91 * (height - 152.4) + rnorm(200, 0, 7)
#' # event <- sample(c(0, 1), 200, rep = TRUE, prob = c(0.1, 0.9))
#' # trt <- factor(sample(c("Group-A", "Group-B", "Group-C"), 200, rep = TRUE))
#' # marker <- factor(sample(c("High", "Low"), 200, rep = TRUE, prob = c(0.3, 0.7)))
#' # sex <- factor(rep(c("M", "F"), each = 50))
#' # mu <- 10 + 0.1 * (age - 65) + as.numeric(sex) + as.numeric(marker) + 5 * (as.numeric(trt) - 2)
#' # time <- rgamma(200, mu, 1)
#' # time[time >= 20] <- 20
#' # event[time == 20] <- 0
#' # dataKm <- data.frame(time, age, height, weight, event, trt, marker, sex)
#' # save(dataKm, file = "dataKm.RData")
#'
#' try(data(dataKm, package = "RcmdrPlugin.KMggplot2"))
#' try(activeDataSet("dataKm"))
#' @seealso km-class
#'
#' @name dataKm
#' @rdname data-dataKm
#' @docType data
#' @keywords data
NULL



#' A Dummy Data for Line Charts
#'
#' @format
#' A data frame with 144 observations on the following 5 variables.
#'   \describe{
#'     \item{\code{date}}{date}
#'     \item{\code{group}}{a measurement group (has three groups "T", "H", and "L")}
#'     \item{\code{marker}}{a biomarker level (has two groups "High", and "Low")}
#'     \item{\code{sex}}{sex}
#'     \item{\code{y}}{a measurement variable}
#'   }
#' @examples
#' # This data is generated by the code below:
#' # set.seed(5435678)
#' # date <- rep(seq(Sys.Date(), len = 12, by = "1 month"), each = 12)
#' # group <- rep(c("T", "H", "L"), 12, each = 4)
#' # marker <- factor(rep(c("High", "Low"), 36, each = 2))
#' # sex <- factor(rep(c("M", "F"), 72))
#' # mu <- rep(c(200, 50, 150), 12, each = 4) + 10 * as.numeric(sex) + 30 * as.numeric(marker)
#' # y <- rnorm(144, mu, 25)
#' # dataLine <- data.frame(date, group, marker, sex, y)
#' # save(dataLine, file = "dataLine.RData")
#'
#' try(data(dataLine, package = "RcmdrPlugin.KMggplot2"))
#' try(activeDataSet("dataLine"))
#' @seealso line-class
#'
#' @name dataLine
#' @rdname data-dataLine
#' @docType data
#' @keywords data
NULL
