% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{parseDatetime}
\alias{parseDatetime}
\alias{parseDouble}
\title{Parse a Datetime vector from a string vector}
\usage{
parseDatetime(svec, fmt = "\%Y-\%m-\%dT\%H:\%M:\%E*S\%Ez", tzstr = "UTC")

parseDouble(svec, fmt = "\%Y-\%m-\%dT\%H:\%M:\%E*S\%Ez", tzstr = "UTC")
}
\arguments{
\item{svec}{A string vector from which a Datetime vector is to be parsed}

\item{fmt}{A string with the format, which is based on \code{strftime} with some
extensions; see the CCTZ documentation for details.}

\item{tzstr}{The local timezone for the desired format}
}
\value{
A Datetime vector object for \code{parseDatetime}, a numeric matrix with
two columns for seconds and nanoseconds for \code{parseDouble}
}
\description{
Parse a Datetime vector
}
\details{
An alternative to \code{as.POSIXct} based on the CCTZ library
}
\examples{
ds <- getOption("digits.secs")
options(digits.secs=6) # max value
parseDatetime("2016-12-07 10:11:12",        "\%Y-\%m-\%d \%H:\%M:\%S");   # full seconds
parseDatetime("2016-12-07 10:11:12.123456", "\%Y-\%m-\%d \%H:\%M:\%E*S"); # fractional seconds
parseDatetime("2016-12-07T10:11:12.123456-00:00")  ## default RFC3339 format
now <- trunc(Sys.time())
parseDatetime(formatDatetime(now + 0:4))	   			# vectorised
options(digits.secs=ds)
}
\author{
Dirk Eddelbuettel
}

