/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.docs;

import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.lysis.reporters.docs.pptx4R;
import org.lysis.reporters.pptx4r.elements.DMLGraphics;
import org.lysis.reporters.pptx4r.elements.DataTable;
import org.lysis.reporters.pptx4r.elements.Date;
import org.lysis.reporters.pptx4r.elements.Footer;
import org.lysis.reporters.pptx4r.elements.Image;
import org.lysis.reporters.pptx4r.elements.Paragraphs;
import org.lysis.reporters.pptx4r.elements.SlideNumber;
import org.lysis.reporters.pptx4r.elements.SubTitle;
import org.lysis.reporters.pptx4r.elements.Title;
import org.lysis.reporters.pptx4r.elements.layouts.SlideLayout;
import org.lysis.reporters.pptx4r.tools.DocExplorer;
import org.lysis.reporters.tables.FlexTable;
import org.pptx4j.pml.CTGraphicalObjectFrame;
import org.pptx4j.pml.Pic;
import org.pptx4j.pml.Shape;
import org.pptx4j.pml.Sld;

public class SlideContent {
    public static int undefined = -1;
    public static int donotexists = 0;
    public static int isfilled = 1;
    public static int noproblem = 2;
    public static int noroomleft = 3;
    public static int undefdimension = 4;
    private SlidePart slidePart;
    private pptx4R itsPPTX;
    private long uidShape;
    private String layoutName;
    private SlideLayout slideLayout;
    private int slideIndex;
    private int freeshapeid;

    public SlideContent(String masterName, pptx4R doc) throws Exception {
        this.layoutName = masterName;
        this.slidePart = doc.getNewSlide(masterName);
        this.itsPPTX = doc;
        this.uidShape = -1L;
        this.freeshapeid = 0;
        this.slideLayout = new SlideLayout(doc.getLayoutProperties(masterName), doc.getMasterLayout());
        this.slideIndex = doc.getSlideNumber();
    }

    public SlideContent(String masterName, pptx4R doc, int slideIndex) throws Exception {
        this.layoutName = masterName;
        this.slidePart = doc.getAndReInitExistingSlide(masterName, slideIndex);
        this.itsPPTX = doc;
        this.uidShape = -1L;
        this.slideLayout = new SlideLayout(doc.getLayoutProperties(masterName), doc.getMasterLayout());
        this.slideIndex = slideIndex;
    }

    public int getmax_shape() {
        return this.slideLayout.getContentSize();
    }

    private void setShapeID() {
        ++this.uidShape;
    }

    public int getNextShapeID() {
        long idx = this.slideLayout.idContent(this.slideLayout.getContentFilled());
        return (int)idx;
    }

    public int getNextIndex() {
        return this.slideLayout.getContentFilled();
    }

    private void setXfrm(CTTransform2D xfrm, CTTransform2D ref) {
        if (ref != null) {
            xfrm.setOff(ref.getOff());
            xfrm.setExt(ref.getExt());
        }
    }

    public int addTitle(String title) {
        boolean isCRT = false;
        if (!this.slideLayout.contains(SlideLayout.TITLE) && this.slideLayout.contains(SlideLayout.CRTTITLE)) {
            isCRT = true;
        }
        if (!isCRT) {
            if (!this.slideLayout.contains(SlideLayout.TITLE)) {
                return donotexists;
            }
            if (this.slideLayout.isFilled(SlideLayout.TITLE)) {
                return isfilled;
            }
            if (this.slideLayout.contains(SlideLayout.TITLE) && !this.slideLayout.isFilled(SlideLayout.TITLE)) {
                try {
                    Shape sTitle = (Shape)Title.getShape(this.slideLayout.id(SlideLayout.TITLE), this.uidShape + 1L, title);
                    ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                    this.slideLayout.setFilled(SlideLayout.TITLE);
                    this.setShapeID();
                    return noproblem;
                }
                catch (Exception e) {
                    return undefined;
                }
            }
            return undefined;
        }
        if (this.slideLayout.isFilled(SlideLayout.CRTTITLE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.CRTTITLE) && !this.slideLayout.isFilled(SlideLayout.CRTTITLE)) {
            try {
                Shape sTitle = (Shape)Title.getShape(this.slideLayout.id(SlideLayout.CRTTITLE), this.uidShape + 1L, title);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                this.slideLayout.setFilled(SlideLayout.CRTTITLE);
                this.setShapeID();
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSubTitle(String title) {
        if (!this.slideLayout.contains(SlideLayout.SUBTITLE)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.SUBTITLE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.SUBTITLE) && !this.slideLayout.isFilled(SlideLayout.SUBTITLE)) {
            try {
                Shape sTitle = (Shape)SubTitle.getShape(this.slideLayout.id(SlideLayout.SUBTITLE), this.uidShape + 1L, title);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sTitle);
                this.slideLayout.setFilled(SlideLayout.SUBTITLE);
                this.setShapeID();
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addDate(String date) {
        if (!this.slideLayout.contains(SlideLayout.DATE)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.DATE)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.DATE) && !this.slideLayout.isFilled(SlideLayout.DATE)) {
            try {
                Shape sDate = (Shape)Date.getShape(this.slideLayout.id(SlideLayout.DATE), this.uidShape + 1L, date);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sDate);
                this.slideLayout.setFilled(SlideLayout.DATE);
                this.setShapeID();
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSlideNumber(String slidenumber) {
        if (!this.slideLayout.contains(SlideLayout.SLIDENUMBER)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.SLIDENUMBER)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.SLIDENUMBER) && !this.slideLayout.isFilled(SlideLayout.SLIDENUMBER)) {
            try {
                Shape sSlideNumber = (Shape)SlideNumber.getShape(this.slideLayout.id(SlideLayout.SLIDENUMBER), this.uidShape + 1L, slidenumber);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sSlideNumber);
                this.slideLayout.setFilled(SlideLayout.SLIDENUMBER);
                this.setShapeID();
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addSlideNumber() {
        return this.addSlideNumber(String.valueOf(this.slideIndex));
    }

    public int addFooter(String footer) {
        if (!this.slideLayout.contains(SlideLayout.FOOTER)) {
            return donotexists;
        }
        if (this.slideLayout.isFilled(SlideLayout.FOOTER)) {
            return isfilled;
        }
        if (this.slideLayout.contains(SlideLayout.FOOTER) && !this.slideLayout.isFilled(SlideLayout.FOOTER)) {
            try {
                Shape sFooter = (Shape)Footer.getShape(this.slideLayout.id(SlideLayout.FOOTER), this.uidShape + 1L, footer);
                ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(sFooter);
                this.slideLayout.setFilled(SlideLayout.FOOTER);
                this.setShapeID();
                return noproblem;
            }
            catch (Exception e) {
                return undefined;
            }
        }
        return undefined;
    }

    public int addPicture(String filename) {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return noroomleft;
        }
        try {
            CTTransform2D xfrm;
            try {
                xfrm = this.slideLayout.getXfrmContent(numContentFilled);
            }
            catch (NullPointerException e) {
                return undefdimension;
            }
            Pic shape = (Pic)Image.getShape(this.itsPPTX.getBaseDocument(), this.slidePart, filename, this.uidShape + 1L, this.slideLayout.idContent(numContentFilled));
            this.setXfrm(shape.getSpPr().getXfrm(), xfrm);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            this.setShapeID();
            this.slideLayout.setContentFilled();
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int addPicture(String filename, double offx, double offy, double width, double height) {
        try {
            ++this.freeshapeid;
            CTTransform2D xfrm = DocExplorer.getXfrm(offx, offy, width, height);
            Pic shape = (Pic)Image.getShape(this.itsPPTX.getBaseDocument(), this.slidePart, filename, this.uidShape + (long)this.freeshapeid, 1L);
            this.setXfrm(shape.getSpPr().getXfrm(), xfrm);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int add(DMLGraphics d) {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return noroomleft;
        }
        try {
            CTTransform2D xfrm;
            try {
                xfrm = this.slideLayout.getXfrmContent(numContentFilled);
            }
            catch (NullPointerException e) {
                return undefdimension;
            }
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.getShape(this.slideLayout.idContent(numContentFilled), this.uidShape + 1L, xfrm.getOff().getX(), xfrm.getOff().getY(), xfrm.getExt().getCx(), xfrm.getExt().getCy()));
            this.slideLayout.setContentFilled();
            this.setShapeID();
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int add(DMLGraphics d, double offx, double offy, double width, double height) {
        try {
            ++this.freeshapeid;
            CTTransform2D xfrm = DocExplorer.getXfrm(offx, offy, width, height);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().addAll(d.getShape(this.uidShape + (long)this.freeshapeid, this.uidShape + (long)this.freeshapeid, xfrm.getOff().getX(), xfrm.getOff().getY(), xfrm.getExt().getCx(), xfrm.getExt().getCy()));
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int add(DataTable obj) {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return noroomleft;
        }
        try {
            CTTransform2D xfrm;
            long idx = this.slideLayout.idContent(numContentFilled);
            try {
                xfrm = this.slideLayout.getXfrmContent(numContentFilled);
            }
            catch (NullPointerException e) {
                return undefdimension;
            }
            CTGraphicalObjectFrame shape = obj.getShape(idx, this.uidShape + 1L, xfrm.getExt().getCx());
            this.setXfrm(shape.getXfrm(), xfrm);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            this.setShapeID();
            this.slideLayout.setContentFilled();
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int[] getShapeDimensions() {
        int[] out = new int[]{-1, -1, -1, -1};
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return out;
        }
        CTTransform2D xfrm = this.slideLayout.getXfrmContent(numContentFilled);
        out[0] = (int)xfrm.getOff().getX();
        out[1] = (int)xfrm.getOff().getY();
        out[2] = (int)xfrm.getExt().getCx();
        out[3] = (int)xfrm.getExt().getCy();
        return out;
    }

    public int add(FlexTable obj) {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return noroomleft;
        }
        try {
            CTTransform2D xfrm;
            long idx = this.slideLayout.idContent(numContentFilled);
            try {
                xfrm = this.slideLayout.getXfrmContent(numContentFilled);
            }
            catch (NullPointerException e) {
                return undefdimension;
            }
            CTGraphicalObjectFrame shape = obj.getShape(idx, this.uidShape + 1L, xfrm.getExt().getCx());
            this.setXfrm(shape.getXfrm(), xfrm);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            this.setShapeID();
            this.slideLayout.setContentFilled();
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int add(FlexTable obj, double offx, double offy, double width, double height) {
        try {
            ++this.freeshapeid;
            CTTransform2D xfrm = DocExplorer.getXfrm(offx, offy, width, height);
            CTGraphicalObjectFrame shape = obj.getShape(this.uidShape + (long)this.freeshapeid, this.uidShape + (long)this.freeshapeid, xfrm.getExt().getCx());
            this.setXfrm(shape.getXfrm(), xfrm);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(shape);
            return noproblem;
        }
        catch (Exception e) {
            return undefined;
        }
    }

    public int add(Paragraphs obj) {
        int numContentFilled = this.slideLayout.getContentFilled();
        if (numContentFilled >= this.slideLayout.getContentSize()) {
            return noroomleft;
        }
        try {
            CTTransform2D XfrmContent;
            long idx = this.slideLayout.idContent(numContentFilled);
            Shape par = obj.getShape(this.uidShape + 1L, idx);
            try {
                XfrmContent = this.slideLayout.getXfrmContent(numContentFilled);
            }
            catch (NullPointerException e) {
                return undefdimension;
            }
            this.setXfrm(par.getSpPr().getXfrm(), XfrmContent);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(par);
            this.setShapeID();
            this.slideLayout.setContentFilled();
            return noproblem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return undefined;
        }
    }

    public int add(Paragraphs obj, double offx, double offy, double width, double height) {
        try {
            ++this.freeshapeid;
            CTTransform2D XfrmContent = DocExplorer.getXfrm(offx, offy, width, height);
            Shape par = obj.getShape(this.uidShape + (long)this.freeshapeid, this.uidShape + (long)this.freeshapeid);
            this.setXfrm(par.getSpPr().getXfrm(), XfrmContent);
            ((Sld)this.slidePart.getJaxbElement()).getCSld().getSpTree().getSpOrGrpSpOrGraphicFrame().add(par);
            return noproblem;
        }
        catch (Exception e) {
            e.printStackTrace();
            return undefined;
        }
    }

    public String getLayoutName() {
        return this.layoutName;
    }
}

