/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.text;

import java.util.LinkedHashMap;
import java.util.Vector;

import org.docx4j.XmlUtils;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.formats.TextProperties;
import org.lysis.reporters.tools.DOCX4R;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;
import org.lysis.reporters.tools.PPTX4R;
import org.pptx4j.pml.Shape;

public class RScript extends DocComponent implements HTML4R, PPTX4R, DOCX4R{
	private LinkedHashMap<Integer, Paragraph> parList;
	private int parIndex;


	private static String SAMPLE_SHAPE_START =                         
            "<p:sp xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\">"
            + "<p:nvSpPr>"
	            + "<p:cNvPr id=\"${id_shape}\" name=\"Title ${title_shape}\" />"
		            + "<p:cNvSpPr>"
		                    + "<a:spLocks noGrp=\"${noGrp}\" />"
		            + "</p:cNvSpPr>"
	            + "<p:nvPr>"
                    + "<p:ph idx=\"${idx}\"/>"//+ "<p:ph idx=\"${idx}\" ${size}/>"
	            + "</p:nvPr>"
		    + "</p:nvSpPr>"
		    + "<p:spPr>"
		      + "<a:xfrm>"
		        + "<a:off x=\"0\" y=\"0\"/>"
		        + "<a:ext cx=\"0\" cy=\"0\"/>"
		      + "</a:xfrm>"
		    + "</p:spPr>"
		    + "<p:txBody>"
	            + "<a:bodyPr /><a:lstStyle />";
	private static String SAMPLE_SHAPE_END = "</p:txBody>" + "</p:sp>";

	
	public RScript( ParProperties parProp ){
		super();
		setParProperties(parProp);
		parIndex = 0;
		parList = new LinkedHashMap<Integer, Paragraph>();
	}
	
	public void addParagraph ( Paragraph par ){
		parIndex++;
		parList.put(parIndex, par);
	}
	public int size(){
		return parIndex ;
	}
		
	public Paragraph get(int i){
		return parList.get(i);
	}
	
	public void setTextProperties(TextProperties tp){
		if( parIndex > 0 )
			for(int i = 1 ; i < parIndex +1 ; i++ ){
				parList.get(i).setTextProperties(tp);
			}
	}
	
	public String toString(){
		String out = "";
		if( parIndex > 0 )
			for(int i = 1 ; i < parIndex +1 ; i++ ){
				out += parList.get(i).toString() ;
			}
		return out;
	}


	@Override
	public String getHTML() {
		String out = "<pre>";
		if( parIndex > 0 ){
			for(int i = 1 ; i < parIndex +1 ; i++ ){
				Paragraph p = parList.get(i);
				p.setVanilla();
				out += parList.get(i).getHTML() + "\n";
			}
		}
		
		out += "</pre>";
		
		return out;
	}

	
	public Shape get_pptx_elt() throws Exception{
		if( !validatePPTXComponent() ) throw new Exception("class RScript: elements need to be set...");

		java.util.HashMap<String, String>mappings = new java.util.HashMap<String, String>();
        mappings.put("id_shape", shape_id + "" );
        mappings.put("title_shape", "Texts" + shape_id);
        mappings.put("idx", unique_id +"" );
        mappings.put("noGrp", "1" );

        Shape o = (Shape) XmlUtils.unmarshallFromTemplate(SAMPLE_SHAPE_START + "<a:p/>" + SAMPLE_SHAPE_END, mappings,org.pptx4j.jaxb.Context.jcPML, Shape.class);
        
		ParagraphSet temp = new ParagraphSet(getParProperties());
		for( int i = 1 ; i <= size() ; i++ ){
			temp.addParagraph(get(i));
		}
		
    	o.setTxBody(temp.get_pptx_parset());

		return o;
	}
	
	public Vector<P> get_docx_elt() throws Exception{
		
		if( !validateDOCXComponent() ) throw new Exception("class RScript: elements need to be set...");

		PPr rpr = getParProperties().get_docx_pp();
		
		Vector<P> out = new Vector<P>();
		
		if( parIndex > 0 ){
			for(int i = 1 ; i < parIndex +1 ; i++ ){
				P temp = parList.get(i).get_docx_par();
				if( i == 1 ) addBookmark(temp);
				temp.setPPr(rpr);
				out.add( temp );
			}
		}
		
		return out;
	}
	
	@Override
	public String getCSS() {
		return "";
	}

	@Override
	public String getJS() {
		return "";
	}

	@Override
	public boolean hasJS() {
		return false;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		return false;
	}


}
