/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.html4r.elements;

import org.apache.commons.lang.StringEscapeUtils;
import org.lysis.reporters.html4r.tools.utils;
import org.lysis.reporters.text.Paragraph;
import org.lysis.reporters.tools.HTML4R;

public class Title
implements HTML4R {
    private String value;
    private Paragraph pot;
    private int level;
    private String uid;

    public Title(String str, int lev) {
        this.value = StringEscapeUtils.escapeHtml((String)str);
        this.level = lev;
        this.uid = utils.generateUniqueId();
    }

    public Title(Paragraph title, int lev) {
        this.pot = title;
        this.level = lev;
        this.uid = utils.generateUniqueId();
        this.value = title.asText();
    }

    public String getUID() {
        return this.uid;
    }

    public int getLevel() {
        return this.level;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getHTML() {
        if (this.pot != null) {
            return utils.title(this.pot.getHTML(), this.level, this.uid);
        }
        return utils.title(this.value, this.level, this.uid);
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }
}

