/*
 * This file is part of ReporteRs
 * Copyright (c) 2014, David Gohel All rights reserved.
 * This program is licensed under the GNU GENERAL PUBLIC LICENSE V3.
 * You may obtain a copy of the License at :
 * http://www.gnu.org/licenses/gpl.html
 */

package org.lysis.reporters.html4r.elements;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;

import org.lysis.reporters.formats.ParProperties;
import org.lysis.reporters.html4r.tools.Format;
import org.lysis.reporters.tools.HTML4R;

public class SVGContent implements HTML4R{
	private String svg_str;
	private ParProperties parProperties;
	private String id;
	private String tooltip_extra_css;// = "padding:5px;background:black;color:white;border-radius:2px 2px 2px 2px;";
	private String hover_css;
	private boolean ggiraph;
	
	public SVGContent(ParProperties pp, String file, String id, String tooltip_extra_css, String hover_css, boolean ggiraph) throws IOException{
		parProperties = pp;
		svg_str = "";
		BufferedReader in = new BufferedReader(new FileReader( file ));
		String s;
		while( (s = in.readLine()) != null) {
			svg_str += s;
		}
		in.close();
		this.id = id;
		this.tooltip_extra_css = tooltip_extra_css;
		this.hover_css = hover_css;
		this.ggiraph = ggiraph;
	}


	@Override
	public String getHTML() {
		LinkedHashMap<String, String> ppr = parProperties.get_html_pp();
		String pStart = "<div style=\"" + Format.getJSString(ppr) + "\">";
		String pStop = "</div>";
		return pStart + svg_str + pStop;
	}

	@Override
	public String getCSS() {
	   if( !ggiraph ) return "";
	   
       String tooltip_class = "tooltip" + id;
       String tooltip_css = "div." + tooltip_class +
                " {position:absolute;pointer-events:none;";
              tooltip_css += tooltip_extra_css + "}";
       tooltip_css += ".cl" + id +  ":{}.cl" + id +  ":hover{" + hover_css + "}";

		return tooltip_css;
	}

	@Override
	public String getJS() {
		if( !ggiraph ) return "";
		String tooltip_class = "tooltip" + id;
		String js = "";
        js += "var div = d3.select(\"body\").append(\"div\").attr(\"class\", \"" + tooltip_class + "\").style(\"opacity\", 0);";
        js += "function d3_set_attr" + id + "(selection, name, value) {selection.attr(name, value);};";
        js += "var sel_data_id = d3.selectAll('#svg_" + id + " *[data-id]');";
        js += "sel_data_id.call(d3_set_attr" + id + ", \"class\", \"cl" + id + "\");";
        js += "var sel_tooltiped = d3.selectAll('#svg_" + id + " *[title]');";
        
        js += "sel_tooltiped.on(\"mouseover\", function(d) {";
        js += "div.transition().duration(200).style(\"opacity\", .90);";
        js += "div.html(d3.select(this).attr(\"title\"))";
        js += ".style(\"left\", (d3.event.pageX + 10 ) + \"px\")";
        js += ".style(\"top\", (d3.event.pageY  ) + \"px\");";
        js += "})";
        js += ".on(\"mouseout\", function(d) {";
        js += "div.transition().duration(500).style(\"opacity\", 0);});";
        js += "function zoom_h" + id + "() {d3.select(this).attr(\"transform\", \"translate(\" + d3.event.translate + \")scale(\" + d3.event.scale + \")\");}";
        js += "var zoom_l" + id + " = d3.behavior.zoom().scaleExtent([1, 8]).on(\"zoom\", zoom_h" + id + ");";
        js += "zoom_l" + id + "(d3.select('#svg_" + id + " g'));";
        
		return js;
	}

	@Override
	public boolean hasJS() {
		return true;
	}

	@Override
	public boolean hasCSS() {
		
		return true;
	}

	@Override
	public boolean hasHTML() {
		return true;
	}


}
