/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import org.apache.commons.io.IOUtils;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.docx4j.TextUtils;
import org.docx4j.convert.in.FlatOpcXmlImporter;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.core.dc.elements.SimpleLiteral;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.io.LoadFromZipNG;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.io3.Load3;
import org.docx4j.openpackaging.io3.Save;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.io3.stores.ZipPartStore;
import org.docx4j.openpackaging.packages.Filetype;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.Parts;
import org.docx4j.xmlPackage.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpcPackage
extends Base {
    private static Logger log = LoggerFactory.getLogger(OpcPackage.class);
    public HashMap<String, String> handled = new HashMap();
    protected Parts parts = new Parts();
    protected HashMap<ExternalTarget, Part> externalResources = new HashMap();
    protected HashMap<String, CustomXmlPart> customXmlDataStorageParts = new HashMap();
    protected ContentTypeManager contentTypeManager;
    private PartStore sourcePartStore;
    private PartStore targetPartStore;
    protected DocPropsCorePart docPropsCorePart;
    protected DocPropsExtendedPart docPropsExtendedPart;
    protected DocPropsCustomPart docPropsCustomPart;

    public Parts getParts() {
        return this.parts;
    }

    public HashMap<ExternalTarget, Part> getExternalResources() {
        return this.externalResources;
    }

    public HashMap<String, CustomXmlPart> getCustomXmlDataStorageParts() {
        return this.customXmlDataStorageParts;
    }

    public ContentTypeManager getContentTypeManager() {
        return this.contentTypeManager;
    }

    public void setContentTypeManager(ContentTypeManager contentTypeManager) {
        this.contentTypeManager = contentTypeManager;
    }

    public PartStore getSourcePartStore() {
        return this.sourcePartStore;
    }

    public void setSourcePartStore(PartStore partStore) {
        this.sourcePartStore = partStore;
    }

    public PartStore getTargetPartStore() {
        return this.targetPartStore;
    }

    public void setTargetPartStore(PartStore partStore) {
        this.targetPartStore = partStore;
    }

    public OpcPackage() {
        try {
            this.partName = new PartName("/", false);
            this.contentTypeManager = new ContentTypeManager();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public OpcPackage(ContentTypeManager contentTypeManager) {
        try {
            this.partName = new PartName("/", false);
            this.contentTypeManager = contentTypeManager;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    @Override
    public OpcPackage getPackage() {
        return this;
    }

    public static OpcPackage load(File docxFile) throws Docx4JException {
        return OpcPackage.load(docxFile, null);
    }

    public static OpcPackage load(File docxFile, String password) throws Docx4JException {
        try {
            return OpcPackage.load((InputStream)new FileInputStream(docxFile), password);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Docx4JException("Couldn't load file from " + docxFile.getAbsolutePath(), e);
        }
    }

    public static OpcPackage load(InputStream inputStream) throws Docx4JException {
        return OpcPackage.load(inputStream, "");
    }

    public static OpcPackage load(InputStream inputStream, String password) throws Docx4JException {
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        bis.mark(0);
        byte[] firstTwobytes = new byte[2];
        int read = 0;
        try {
            read = bis.read(firstTwobytes);
            bis.reset();
        }
        catch (IOException e) {
            throw new Docx4JException("Error reading from the stream", e);
        }
        if (read != 2) {
            throw new Docx4JException("Error reading from the stream (no bytes available)");
        }
        if (firstTwobytes[0] == 80 && firstTwobytes[1] == 75) {
            return OpcPackage.load(bis, Filetype.ZippedPackage, null);
        }
        if (firstTwobytes[0] == -48 && firstTwobytes[1] == -49) {
            log.info("Detected compound file");
            return OpcPackage.load(bis, Filetype.Compound, password);
        }
        log.info("Assuming Flat OPC XML");
        return OpcPackage.load(bis, Filetype.FlatOPC, null);
    }

    @Deprecated
    public static OpcPackage load(InputStream is, boolean docxFormat) throws Docx4JException {
        return OpcPackage.load(is);
    }

    public static OpcPackage load(InputStream is, Filetype type) throws Docx4JException {
        return OpcPackage.load(is, type, null);
    }

    public static OpcPackage load(InputStream is, Filetype type, String password) throws Docx4JException {
        if (type.equals((Object)Filetype.ZippedPackage)) {
            ZipPartStore partLoader = new ZipPartStore(is);
            Load3 loader = new Load3(partLoader);
            return loader.get();
        }
        if (type.equals((Object)Filetype.Compound)) {
            try {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                EncryptionInfo info = new EncryptionInfo(fs);
                Decryptor d = Decryptor.getInstance((EncryptionInfo)info);
                d.verifyPassword(password);
                InputStream is2 = d.getDataStream(fs);
                LoadFromZipNG loader = new LoadFromZipNG();
                return loader.get(is2);
            }
            catch (InvalidKeyException e) {
                throw new Docx4JException("Problem reading compound file: wrong password?", e);
            }
            catch (Exception e) {
                throw new Docx4JException("Problem reading compound file", e);
            }
        }
        try {
            FlatOpcXmlImporter xmlPackage = new FlatOpcXmlImporter(is);
            return xmlPackage.get();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new Docx4JException("Couldn't load xml from stream ", e);
        }
    }

    public void save(File file) throws Docx4JException {
        this.save(file, null);
    }

    private void save(File file, String password) throws Docx4JException {
        if (file.getName().endsWith(".xml")) {
            FlatOpcXmlCreator worker = new FlatOpcXmlCreator(this);
            Package pkg = worker.get();
            try {
                worker.marshal(new FileOutputStream(file));
            }
            catch (Exception e) {
                throw new Docx4JException("Error saving Flat OPC XML", e);
            }
            return;
        }
        if (password == null) {
            Save saver = new Save(this);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                saver.save(fos);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new Docx4JException("Couldn't save " + file.getPath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
            this.docPropsCorePart = (DocPropsCorePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties")) {
            this.docPropsCustomPart = (DocPropsCustomPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties")) {
            this.docPropsExtendedPart = (DocPropsExtendedPart)part;
            return true;
        }
        return false;
    }

    public DocPropsCorePart getDocPropsCorePart() {
        return this.docPropsCorePart;
    }

    public DocPropsExtendedPart getDocPropsExtendedPart() {
        return this.docPropsExtendedPart;
    }

    public DocPropsCustomPart getDocPropsCustomPart() {
        return this.docPropsCustomPart;
    }

    public void setTitle(String title) {
        if (this.getDocPropsCorePart() == null) {
            try {
                DocPropsCorePart core = new DocPropsCorePart();
                org.docx4j.docProps.core.ObjectFactory coreFactory = new org.docx4j.docProps.core.ObjectFactory();
                core.setJaxbElement(coreFactory.createCoreProperties());
                this.addTargetPart(core);
            }
            catch (InvalidFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        ObjectFactory of = new ObjectFactory();
        SimpleLiteral literal = of.createSimpleLiteral();
        literal.getContent().add(title);
        ((CoreProperties)this.getDocPropsCorePart().getJaxbElement()).setTitle(of.createTitle(literal));
    }

    public String getTitle() {
        if (this.getDocPropsCorePart() == null) {
            return null;
        }
        JAXBElement<SimpleLiteral> sl = ((CoreProperties)this.getDocPropsCorePart().getJaxbElement()).getTitle();
        if (sl == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            TextUtils.extractText(sl, sw, Context.jcDocPropsCore);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return sw.toString();
    }

    public OpcPackage clone() {
        OpcPackage result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SaveToZipFile saver = new SaveToZipFile(this);
        try {
            saver.save(baos);
            result = OpcPackage.load(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (Docx4JException e) {
            e.printStackTrace();
        }
        return result;
    }
}

