\name{HOMFLYpolynomial}
\alias{HOMFLYpolynomial}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Compute the HOMFLY polynomial of a polygonal link
%%  ~~function to do ... ~~
}
\description{Compute the HOMFLY polynomial of a polygonal link, given its skein tree 
(generated by \code{skeinIterator})
}

\usage{
HOMFLYpolynomial(leaves, tree, skein.sign = -1)
}

\arguments{
	\item{leaves}{a list containing the binary indices of the 
	tree leaves}
	\item{tree}{a list containing the skein tree as 
	returned by \code{skeinIterator}. }
	\item{skein.sign}{the skein sign to be used (+1 or -1)}
}

\details{The polynomial computation relies on \code{rSymPy}. 
Please notice that the first time sympy is invoked is expected to be 
much slower than subsequent ones. 
}

\value{
the HOMFLY polynomial
}

\note{
This is a low-level function.
}

\references{
	Freyd P, Yetter D, Hoste J, Lickorish WBR, Millett K, et al.
	 (1985) A new polynomial invariant of knots and links. Bull Amer Math Soc (NS) 12: 239-246.
	
	Kauffman, L. Knots and Physics. Teaneck, NJ: World Scientific, p. 19, 1991.
	
	Comoglio F. and Rinaldi M. (2011) A Topological Framework for the Computation of the HOMFLY Polynomial and Its Application to Proteins 
	PLoS ONE 6(4): e18693, doi:10.1371/journal.pone.0018693 
	ArXiv:1104.3405
}

\author{
Federico Comoglio, federico.comoglio@bsse.ethz.ch
}

\seealso{
\code{\link{HOMFLY2mirror}},
\code{\link{HOMFLY2Alexander}},
\code{\link{HOMFLY2Jones}}
}

\examples{
\dontrun{
## Import a PDB file from the file system
protein <- makeExampleProtein()

## Reduce to minimal structure
protein.reduced <- AlexanderBriggs(protein$A)

## Compute the skein tree
tree <- skeinIterator(protein.reduced$points3D, protein.reduced$ends)
	
## Compute the HOMFLY polynomial
HOMFLYpolynomial(tree$leaves, tree$tree, skein.sign = -1)
}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{invariants}
% \keyword{ ~kwd2 }% __ONLY ONE__ keyword per line