% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfit.R
\name{plotfit}
\alias{plotfit}
\title{Plot the fitted density function for one or more experts}
\usage{
plotfit(
  fit,
  d = "best",
  xl = -Inf,
  xu = Inf,
  yl = 0,
  yu = NA,
  ql = NA,
  qu = NA,
  lp = FALSE,
  ex = NA,
  sf = 3,
  ind = TRUE,
  lpw = 1,
  fs = 12,
  lwd = 1,
  xlab = "x",
  ylab = expression(f[X](x)),
  legend_full = TRUE,
  percentages = FALSE,
  returnPlot = FALSE,
  showPlot = TRUE
)
}
\arguments{
\item{fit}{An object of class \code{elicitation}.}

\item{d}{The distribution fitted to each expert's probabilities. Options are
\code{"normal"}, \code{"t"}, \code{"skewnormal"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"mirrorgamma"},
\code{"mirrorlognormal"}, \code{"mirrorlogt"} \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting)}

\item{xl}{The lower limit for the x-axis. The default is the 0.001 quantile
of the fitted distribution (or the 0.001 quantile of a fitted normal
distribution, if a histogram fit is chosen).}

\item{xu}{The upper limit for the x-axis. The default is the 0.999 quantile
of the fitted distribution (or the 0.999 quantile of a fitted normal
distribution, if a histogram fit is chosen).}

\item{yl}{The lower limit for the y-axis. Default value is 0.}

\item{yu}{The upper limit for the y-axis. Will be set automatically if not specified.}

\item{ql}{A lower quantile to be indicated on the density function plot.
Only displayed when plotting the density function for a single expert.}

\item{qu}{An upper quantile to be indicated on the density function plot.
Only displayed when plotting the density function for a single expert.}

\item{lp}{For multiple experts, set \code{lp = TRUE} to plot a linear pool.}

\item{ex}{If judgements have been elicited from multiple experts, but a
density plot for one expert only is required, the expert to be used in the
plot.}

\item{sf}{The number of significant figures to be displayed for the
parameter values.}

\item{ind}{If plotting a linear pool, set \code{ind = FALSE} to suppress
plotting of the individual density functions.}

\item{lpw}{A vector of weights to be used in linear pool, if unequal
weighting is desired.}

\item{fs}{The font size used in the plot.}

\item{lwd}{The line width used in the plot.}

\item{xlab}{A string or expression giving the x-axis label.}

\item{ylab}{A string or expression giving the y-axis label.}

\item{legend_full}{If plotting a linear pool, set \code{ind = TRUE} for each expert
to be plotted with a different colour, and \code{ind = FALSE} for each expert to be 
plotted with the same colour, reducing the legend size.}

\item{percentages}{Set to \code{TRUE} to use percentages on the x-axis.}

\item{returnPlot}{Set to \code{TRUE} to return the plot as a ggplot object.}

\item{showPlot}{Set to \code{FALSE} to suppress displaying the plot.}
}
\description{
Plots the fitted density function for one or more experts. Can also plot a
fitted linear pool if more than one expert. If plotting the density function
of one expert, or the linear pool only, can also indicated desired lower and
upper fitted quantiles.
}
\examples{

\dontrun{
# Two experts
# Expert 1 states P(X<30)=0.25, P(X<40)=0.5, P(X<50)=0.75
# Expert 2 states P(X<20)=0.25, P(X<25)=0.5, P(X<35)=0.75
# Both experts state 0<X<100. 

v <- matrix(c(30, 40, 50, 20, 25, 35), 3, 2)
p <- c(0.25, 0.5, 0.75)
myfit <- fitdist(vals = v, probs = p, lower = 0, upper = 100)

# Plot both fitted densities, using the best fitted distribution
plotfit(myfit)

# Plot a fitted beta distribution for expert 2, and show 5th and 95th percentiles
plotfit(myfit, d = "beta", ql = 0.05, qu = 0.95, ex = 2)


# Plot a linear pool, giving double weight to expert 1
plotfit(myfit,  lp = T, lpw = c(2,1))


# Plot a linear pool, giving double weight to expert 1, 
# show 5th and 95th percentiles, surpress plotting of individual distributions, 
# and force use of Beta distributions
plotfit(myfit, d = "beta",  lp = T, lpw = c(2,1), ql = 0.05, qu = 0.95, ind=FALSE )
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
