% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareExperts.R
\name{compareIntervals}
\alias{compareIntervals}
\title{Plot fitted intervals for each expert}
\usage{
compareIntervals(
  fit,
  interval = 0.95,
  dist = "best",
  fs = 12,
  xlab = "x",
  ylab = "expert"
)
}
\arguments{
\item{fit}{An object of class \code{elicitation}}

\item{interval}{The probability p for each interval (i.e. the fitted probability for each expert 
that the displayed interval contains the uncertain quantity will be p)}

\item{dist}{The distribution fitted to each expert's probabilities. Options are
\code{"normal"}, \code{"t"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, and
\code{"best"} (for best fitting). Can be a vector if different distributions are desired for each expert.}

\item{fs}{font size used in the plot.}

\item{xlab}{A string or expression giving the x-axis label.}

\item{ylab}{A string or expression giving the y-axis label.}
}
\description{
Following elicitation of distributions from individual experts, plot fitted probability 
intervals for each expert.
}
\examples{

\dontrun{
v <- matrix(c(30, 40, 50, 20, 25, 35, 40, 50, 60, 35, 40, 50), 3, 4)
p <- c(0.25, 0.5, 0.75)
myfit <- fitdist(vals = v, probs = p, lower = 0, upper = 100)
compareIntervals(myfit, interval = 0.5)
}
}
