% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectiveFunctionEvaluation.R
\name{objectiveFunctionEvaluation}
\alias{objectiveFunctionEvaluation}
\title{Objective Function Evaluation}
\usage{
objectiveFunctionEvaluation(
  x = NULL,
  xnew,
  fun,
  seedFun = NA,
  noise = FALSE,
  ...
)
}
\arguments{
\item{x}{matrix of already known solutions, to determine whether RNG seeds for new solutions need to be incremented.}

\item{xnew}{matrix of new solutions.}

\item{fun}{objective function to evaluate the solutions in \code{xnew}.}

\item{seedFun}{initial seed to be used for the random number generator seed. Set to NA to avoid using a fixed seed.}

\item{noise}{parameter specifying whether the target function is noisy.}

\item{...}{parameters passed to \code{fun}.}
}
\value{
the matrix ynew, which are the observations for fun(xnew)
}
\description{
This function handles the evaluation of the objective function in \code{\link{spot}}.
This includes handling of the random number generator stream as well as the actual evaluation.
}
\seealso{
\code{\link{spot}} for more details on the parameters, e.g., \code{fun}
}
\keyword{internal}
