% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handleNAs.R
\name{getPositions}
\alias{getPositions}
\title{get impute positions}
\usage{
getPositions(y, imputeCriteriaFuns = list(is.na, is.infinite, is.nan))
}
\arguments{
\item{y}{The vector of numerics from which NA/Inf values should be removed}

\item{imputeCriteriaFuns}{\code{list} criteria functions specified via
\code{imputeCriteriaFuns} in \code{\link{spotControl}}.
Default: \code{list(is.na, is.infinite, is.nan)}.}
}
\value{
p vector of positions that fulfill one of the criteria
}
\description{
Determines positions in a vectors
that fulfill criteria defined by a list
of criteria, e.g., \code{is.na}.
}
\examples{
imputeCriteriaFuns <- list(is.na, is.infinite, is.nan)
y <- c(1,2,Inf,4,NA,6)
p <- getPositions(y, imputeCriteriaFuns)
}
