\name{brt4df}
\alias{brt4df}
\title{Get Backward Recurrence Times from Data Frames Generated by mkGLMdf}
\description{
  Spike trains discharge models for single neurons are rarely
  renewal. They require more information than just the elapsed time
  since the last spike. Function \code{brt4df} generates this additional
  information from a data frame obtained by \code{mkGLMdf}.
}

\usage{
brt4df(df, varName, max.order = 1, colNames,
       auto = TRUE, normalise = function(x) as.numeric(scale(log(x))))
}

\arguments{
  \item{df}{A \code{\link{data.frame}} generated by
    \code{\link{mkGLMdf}} and containing the events of a single neuron.}
  \item{varName}{The name of one of the variables of \code{df}. It
    should be one of the "elapsed time" variables, like, \code{lN.x},
    where \code{x} stands for a neuron number.}
  \item{max.order}{How many events should looked for in the past?}
  \item{colNames}{Names of the columns of the returned
    \code{\link{data.frame}}. If missing default names are provided.}
  \item{auto}{A logical. Does \code{varName} refer to the elapsed times
    since the last spike of the neuron whose spikes are recorded in the
    \code{event} variable (\code{TRUE}) or not (\code{FALSE})?}
  \item{normalise}{A \code{\link{function}} applied to the extracted
    data in order to normalise them. If missing ,nothing is done and the
    extracted data are left unchanged.}
}
\details{
  If the spike required to evaluate the elapsed time is not contained in
  \code{df} then \code{NA} will be the reported elapsed time. 
}
\value{
  A \code{\link{data.frame}} is returned with as many variable as
  \code{max.order} and as many rows as \code{df}.
}
\references{
  Kass, Robert E. and Ventura, Val\'erie (2001) A spike-train
  probability model \emph{Neural Comput.} \bold{13}: 1713--1720.

  Truccolo, W., Eden, U. T., Fellows, M. R., Donoghue, J. P. and Brown,
  E. N. (2005) A Point Process Framework for Relating Neural Spiking
  Activity to Spiking History, Neural Ensemble and Extrinsic Covariate
  Effects \emph{J Neurophysiol} \bold{93}:
  1074--1089. \url{http://jn.physiology.org/cgi/content/abstract/93/2/1074} 
}
\author{Christophe Pouzat  \email{christophe.pouzat@gmail.com}}
\seealso{
  \code{\link{mkGLMdf}},
  \code{\link{data.frame}},
  \code{\link{glm}},
  \code{\link{mgcv}}
}

\examples{
\dontrun{
## Let us consider neuron 1 of the CAL2S data set
data(CAL2S)
CAL2S <- lapply(CAL2S,as.spikeTrain)
CAL2S[["neuron 1"]]
renewalTestPlot(CAL2S[["neuron 1"]])
summary(CAL2S[["neuron 1"]])
## Make a data frame with a 4 ms time resolution
cal2Sdf <- mkGLMdf(CAL2S,0.004,0,60)
## keep the part relative to neuron 1
n1.cal2sDF <- cal2Sdf[cal2Sdf$neuron=="1",]
## remove unnecessary data
rm(cal2Sdf)
## Extract the elapsed time since the second to last and
## third to last for neuron 1. Normalise the result. 
n1.cal2sDF[c("rlN.1","rsN.1","rtN.1")] <- brt4df(n1.cal2sDF,"lN.1",2,c("rlN.1","rsN.1","rtN.1"))
## load mgcv library
library(mgcv)
## fit a model with a tensorial product involving the last
## three spikes and using a cubic spline basis for the last two
n1S.fitA <- gam(event ~ te(rlN.1,rsN.1,bs="cr") + rtN.1,data=n1.cal2sDF,family=binomial(link="logit"))
summary(n1S.fitA)
## plot the result in 2 different ways
plot(n1S.fitA)
vis.gam(n1S.fitA,phi=20,theta=45)

}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models}

