% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{aggreswmp}
\alias{aggreswmp}
\alias{aggreswmp.swmpr}
\title{Aggregate swmpr data}
\usage{
aggreswmp(swmpr_in, ...)

\method{aggreswmp}{swmpr}(swmpr_in, by, FUN = function(x) mean(x, na.rm =
  TRUE), params = NULL, aggs_out = FALSE, na.action = na.pass, ...)
}
\arguments{
\item{swmpr_in}{input swmpr object}

\item{...}{additional arguments passed to other methods}

\item{by}{chr string of time period for aggregation one of \code{'years'}, \code{'quarters'}, \code{'months'}, \code{'weeks'}, \code{'days'}, or \code{'hours'}}

\item{FUN}{aggregation function, default \code{mean} with \code{na.rm = TRUE}}

\item{params}{names of parameters to aggregate, default all}

\item{aggs_out}{logical indicating if \code{\link[base]{data.frame}} is returned of raw data with datetimestamp formatted as aggregation period, default \code{FALSE}}

\item{na.action}{function for treating missing data, default \code{na.pass}}
}
\value{
Returns an aggregated swmpr object. QAQC columns are removed if included with input object.
}
\description{
Aggregate swmpr data by specified time period and method
}
\details{
The function aggregates parameter data for a swmpr object by set periods of observation and a user-supplied function. It is most useful for aggregating noisy data to evaluate trends on longer time scales, or to simply reduce the size of a dataset. Data can be aggregated by \code{'years'}, \code{'quarters'}, \code{'months'}, \code{'weeks'}, \code{'days'}, or \code{'hours'} for the supplied function, which defaults to the \code{\link[base]{mean}}. A swmpr object is returned for the aggregated data, although the datetimestamp vector will be converted to a date object if the aggregation period is a day or longer. Days are assigned to the date vector if the aggregation period is a week or longer based on the round method for \code{\link[data.table]{IDate}} objects. This approach was used to facilitate plotting using predefined methods for Date and POSIX objects.

The method of treating NA values for the user-supplied function should be noted since this may greatly affect the quantity of data that are returned (see the examples). Finally, the default argument for \code{na.action} is set to \code{na.pass} for swmpr objects to preserve the time series of the input data.
}
\examples{
## get data, prep
data(apacpwq)
dat <- apacpwq
swmpr_in <- subset(qaqc(dat), rem_cols = TRUE)

## get mean DO by quarters
aggreswmp(swmpr_in, 'quarters', params = c('do_mgl'))

## get variance of DO by years, remove NA when calculating variance
## omit NA data in output
fun_in <- function(x)  var(x, na.rm = TRUE)
aggreswmp(swmpr_in, FUN = fun_in, 'years')
}
\seealso{
\code{\link[stats]{aggregate}}
}

