% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/swmpr_retrieval.R
\name{single_param}
\alias{single_param}
\title{Get CDMO records for a single parameter}
\usage{
single_param(station_code, param, Max = 500)
}
\arguments{
\item{station_code}{chr string of station, 7 or 8 characters}

\item{param}{chr string for a single parameter to return.}

\item{Max}{numeric value for number of records to obtain from the current date, maximum of 500}
}
\value{
Returns a swmpr object with one parameter.  QAQC columns are not provided.
}
\description{
Get stations records from the CDMO for a single parameter starting with the most current date
}
\details{
This function retrieves data from the CDMO through the web services URL. The computer making the request must have a registered IP address.  Visit the CDMO web services page for more information: \url{http://cdmo.baruch.sc.edu/webservices.cfm}.  This function is the CDMO equivalent of \code{exportSingleParamXML}.
}
\examples{
\dontrun{

## single parameter for a station, most recent
single_param('hudscwq', 'do_mgl')

}
}
\seealso{
\code{\link{all_params}}, \code{\link{all_params_dtrng}}
}

