% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/swmpr_analyze.R
\name{hist.swmpr}
\alias{hist.swmpr}
\title{Plot swmpr using a histogram}
\usage{
\method{hist}{swmpr}(x, ...)
}
\arguments{
\item{x}{input swmpr object}

\item{...}{other arguments passed to \code{\link[graphics]{hist}}}
}
\description{
Plot a histogram showing the distribution of a swmpr parameter
}
\details{
The swmpr method for histograms is a convenience function for the default histogram function.  Conventional histogram methods also work well since swmpr objects are also data frames.  The input data must contain only one parameter.
}
\examples{
## get data
data(apadbwq)
dat <- subset(apadbwq, select = 'do_mgl')

## histogram using swmpr method
hist(dat)

## change axis labels, plot title
hist(dat, xlab = 'Dissolved oxygen', main = 'Histogram of DO')

## plot using default method
hist(dat$do_mgl)
}
\seealso{
\code{\link[graphics]{hist}}
}
\concept{
analyze
}

