% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swmpr_misc.R
\docType{data}
\name{apadbwq}
\alias{apadbwq}
\title{Example water quality data for Apalachicola Bay Dry Bar station.}
\format{A \code{\link{swmpr}} object and \code{\link[base]{data.frame}} with 70176 rows and 25 variables:
\describe{
  \item{\code{datetimestamp}}{POSIXct}
  \item{\code{temp}}{num}
  \item{\code{f_temp}}{chr}
  \item{\code{spcond}}{num}
  \item{\code{f_spcond}}{chr}
  \item{\code{sal}}{num}
  \item{\code{f_sal}}{chr}
  \item{\code{do_pct}}{num}
  \item{\code{f_do_pct}}{chr}
  \item{\code{do_mgl}}{num}
  \item{\code{f_do_mgl}}{chr}
  \item{\code{depth}}{num}
  \item{\code{f_depth}}{chr}
  \item{\code{cdepth}}{num}
  \item{\code{f_cdepth}}{chr}
  \item{\code{level}}{num}
  \item{\code{f_level}}{chr}
  \item{\code{clevel}}{num}
  \item{\code{f_clevel}}{chr}
  \item{\code{ph}}{num}
  \item{\code{f_ph}}{chr}
  \item{\code{turb}}{num}
  \item{\code{f_turb}}{chr}
  \item{\code{chlfluor}}{num}
  \item{\code{f_chlfluor}}{chr}
}}
\source{
\url{https://s3.amazonaws.com/swmpexdata/zip_ex.zip}
}
\usage{
apadbwq
}
\description{
An example water quality dataset for Apalachicola Bay Dry Bar station.  The data are a \code{\link{swmpr}} object that have been imported into R from csv files using the \code{\link{import_local}} function.  The raw data were obtained from the CDMO data portal but can also be accessed from a zip file created for this package.  See the source below.  The help file for the \code{\link{import_local}} function describes how the data can be imported from the zip file.  Attributes of the dataset include \code{names}, \code{row.names}, \code{class}, \code{station}, \code{parameters}, \code{qaqc_cols}, \code{date_rng}, \code{timezone}, and \code{stamp_class}.
}
\examples{
data(apadbwq)
}
\keyword{datasets}

