% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.t.R
\encoding{UTF-8}
\name{matrix.t}
\alias{matrix.t}
\title{Matrix T}
\usage{
matrix.t(comm, traits, scale = TRUE, ranks = TRUE, notification = TRUE)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.}

\item{traits}{Matrix or data frame of species described by traits, with traits as
columns and species as rows.}

\item{scale}{Logical argument (TRUE or FALSE) to specify if the traits are
measured on different scales (Default scale = TRUE). When scale = TRUE traits
are measured on different scales and the matrix T is subjected to
standardization within each trait. When scale = FALSE traits are measured on
the same scale the matrix T is not subjected to standardization.}

\item{ranks}{Logical argument (TRUE or FALSE) to specify if ordinal variables are
convert to ranks (Default ranks = TRUE).}

\item{notification}{Logical argument (TRUE or FALSE) to specify if
notifications of missing observations are shown (Default notification =
TRUE).}
}
\value{
\item{matriz.w}{Standardized community matrix, where rows are
communities and columns species. Row totals (communities) = 1.}
\item{matriz.b}{Matrix of traits, exactly the same data input.}
\item{matriz.T}{Matrix containing trait averages at community level. If
Scale = TRUE the matrix T is standardized within the traits.}
}
\description{
Function to obtain a matrix containing trait averages at community level.
For more details, see \code{\link{syncsa}}.
}
\note{
\strong{IMPORTANT}: The sequence species show up in community data
matrix MUST be the same as they show up in traits matrix. See
\code{\link{organize.syncsa}}.
}
\examples{
data(ADRS)
matrix.t(ADRS$community, ADRS$traits)
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.

Pillar, V.D., Duarte, L.d.S., Sosinski, E.E. & Joner, F. (2009).
Discriminating trait-convergence and trait-divergence assembly patterns in
ecological community gradients. Journal of Vegetation Science, 20, 334:348.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}},
\code{\link{matrix.p}}, \code{\link{matrix.x}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
