% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\alias{Correlation}
\alias{correlation.formula}
\alias{correlation.default}
\alias{is.Correlation}
\alias{is.correlation}
\alias{as.Correlation}
\alias{as.correlation}
\alias{print.Correlation}
\alias{summary.Correlation}
\alias{print.summary.Correlation}
\alias{plot.Correlation}
\alias{lines.Correlation}
\title{Correlation matrices.}
\usage{
correlation(x, ...)

Correlation(x, ...)

\method{correlation}{formula}(formula, data = NULL, subset, na.action, ...)

\method{correlation}{default}(x, y = NULL, use = "everything",
  method = c("pearson", "kendall", "spearman"), ...)

is.Correlation(x)

is.correlation(x)

as.Correlation(x)

as.correlation(x)

\method{print}{Correlation}(x, digits = 3, cutoff = 0, ...)

\method{summary}{Correlation}(object, cutpoints = c(0.3, 0.6, 0.8, 0.9, 0.95),
  symbols = c(" ", ".", ",", "+", "*", "B"), ...)

\method{print}{summary.Correlation}(x, ...)

\method{plot}{Correlation}(x, y = NULL, outline = TRUE, cutpoints = c(0.3,
  0.6, 0.8, 0.9, 0.95), palette = rwb.colors, col = NULL, numbers = TRUE,
  digits = 2, type = c("full", "lower", "upper"), diag = (type == "full"),
  cex.lab = par("cex.lab"), cex = 0.75 * par("cex"), ...)

\method{lines}{Correlation}(x, choices = 1L:2L, col = par("col"), lty = 2,
  ar.length = 0.1, pos = NULL, cex = par("cex"), labels = rownames(x),
  ...)
}
\arguments{
\item{x}{A numeric vector, matrix or data frame (or any object for
\code{is.Correlation()}, \code{as.Correlation()}.}

\item{...}{Further arguments passed to functions.}

\item{formula}{A formula with no response variable, referring only to numeric
variables.}

\item{data}{An optional data frame (or similar: see \code{\link[=model.frame]{model.frame()}})
containing the variables in the formula \code{formula}. By default the variables
are taken from \code{environment(formula)}.}

\item{subset}{An optional vector used to select rows (observations) of the
data matrix \code{x}.}

\item{na.action}{A function which indicates what should happen when the data
contain \code{NA}s. The default is set by the \code{na.action =} setting of \code{options()}
and \code{na.fail()} is used if that is not set. The 'factory-fresh' default is
\code{na.omit()}.}

\item{y}{\code{NULL} (default), or a vector, matrix or data frame with compatible
dimensions to \code{x} for \code{Correlation()}. The default is equivalent to \code{x = y},
but more efficient.}

\item{use}{An optional character string giving a method for computing
correlations in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}.}

\item{method}{A character string indicating which correlation coefficient is
to be computed. One of \code{"pearson"} (default), \code{"kendall"}, or \code{"spearman"},
can be abbreviated.}

\item{digits}{Digits to print after the decimal separator.}

\item{cutoff}{Correlation coefficients lower than this (in absolute value)
are suppressed.}

\item{object}{A 'Correlation' object.}

\item{cutpoints}{The cut points to use for categories. Specify only positive
values (absolute value of correlation coefficients are summarized, or
negative equivalents are automatically computed for the graph. Do not include
0 or 1 in the cutpoints).}

\item{symbols}{The symbols to use to summarize the correlation matrix.}

\item{outline}{Do we draw the outline of the ellipse?}

\item{palette}{A function that can produce a palette of colors.}

\item{col}{Color of the ellipse. If \code{NULL} (default), the colors will be
computed using \code{cutpoints =} and \code{palette =}.}

\item{numbers}{Do we print correlation values in the center of the ellipses?}

\item{type}{Do we plot a complete matrix, or only lower or upper triangle?}

\item{diag}{Do we plot items on the diagonal? They have always a correlation
of one.}

\item{cex.lab}{The expansion factor for labels.}

\item{cex}{The expansion factor for text.}

\item{choices}{The items to select}

\item{lty}{The line type to draw.}

\item{ar.length}{The length of the arrow head.}

\item{pos}{The position relative to arrows.}

\item{labels}{The label to draw nead arrows.}
}
\value{
\code{Correlation()} and \code{as.Correlation()`` create a 'Correlation' object, while}is.Correlation()`` tests for it.

There are \code{print()} and \code{summary()} methods for the 'Correlation' object
that differ in the symbolic encoding of the correlations in \code{summary()},
using5 symnum()], which makes large correlation matrices more readable.

The method \code{plot()} returns nothing, but it draws ellipses on a graph that
represent the correlation matrix visually. This is essentially the
\code{\link[=plotcorr]{plotcorr()}} function from package \strong{ellipse}, with slightly different
default arguments and with default \code{cutpoints} equivalent to those used in
the \code{summary()} method.
}
\description{
Compute the correlation matrix between two variables, or more (between all
columns of a matrix or data frame).
}
\examples{
# This is a simple correlation coefficient
cor(rnorm(10), runif(10))
Correlation(rnorm(10), runif(10))

# 'Correlation' objects allow better inspection of the correlation matrices
# than the output of default R cor() function
(longley.cor <- Correlation(longley))
summary(longley.cor) # Synthetic view of the correlation matrix
plot(longley.cor)    # Graphical representation

# Use of the formula interface
(mtcars.cor <- Correlation(~ mpg + cyl + disp + hp, data = mtcars,
  method = "spearman", na.action = "na.omit"))

mtcars.cor2 <- Correlation(mtcars, method = "spearman")
print(mtcars.cor2, cutoff = 0.6)
summary(mtcars.cor2)
plot(mtcars.cor2, type = "lower")

mtcars.cor2["mpg", "cyl"] # Extract a correlation from the correlation matrix
}
\seealso{
\code{\link[=cov]{cov()}}, \code{\link[=cov2cor]{cov2cor()}}, \code{\link[=cov.wt]{cov.wt()}}, \code{\link[=symnum]{symnum()}}, \code{\link[=plotcorr]{plotcorr()}} and look
at \code{\link[=panel_cor]{panel_cor()}}
}
\author{
Philippe Grosjean \href{mailto:phgrosjean@sciviews.org}{phgrosjean@sciviews.org}, wrapping code in package
ellipse, function \code{\link[=plotcorr]{plotcorr()}} for the \code{plot.Correlation()} method.
}
\concept{
correlation matrix and plot
}
\keyword{distribution}
