% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{keep}
\alias{keep}
\title{Subset data}
\usage{
keep(data, select, subset, drop = FALSE, refactor = c("subset.vars", "all",
  "none"), sample = NULL, ...)
}
\arguments{
\item{data}{= .data}

\item{select}{the columns to select from \code{data}.}

\item{subset}{the elements or rows to keep from \code{data} (missing values are taken as false).}

\item{drop}{passed on to [ indexing operator.}

\item{refactor}{whether the levels of variable(s) with zero count should be removed after subsetting. The default is \code{refactor="subset.vars"}, which means that the levels of the variables not being used will be recycled.}

\item{sample}{an integer for the size of random sample to retain from the \code{data}.}

\item{\dots}{typically unecessary parameters.}
}
\description{
Subsets a \code{data.frame} based on variables or/and records. It is a version of \sQuote{subset.data.frame} which is a standard R function.
}
\examples{
data(ssex)
info(ssex)
keep(ssex, select = c(Date, Oppose, Favor))

keep(ssex, subset=Oppose!="NA") # subset
}

