% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multiplot.R
\encoding{UTF-8}
\name{multiplot}
\alias{multiplot}
\title{Multiple ggplot objects}
\usage{
multiplot(..., ncols = 1, layout = NULL)
}
\arguments{
\item{ncols}{number of columns in layout}

\item{layout}{a matrix specifying the layout. If present, 'ncols' is ignored.}

\item{\dots}{a list of ggplot objects}
}
\description{
ggplot objects can be passed in ..., or to plotlist (as a list of ggplot objects)
}
\details{
If the layout is something like matrix(c(1,2,3,3), nrow=2, byrow=TRUE), then plot 1 will go in the upper left, 2 will go in the upper right, and 3 will go all the way across the bottom.
}
\examples{
# Load the diamonds dataset
data(diamonds)
# Create a histogram, assign to "plot1"
plot1 <- qplot(price,data=diamonds,binwidth=1000)
 # Create a scatterplot
plot2 <- qplot(carat,price,data=diamonds)
# Arrange and display the plots into a 1x2 grid
multiplot(plot1, plot2, ncols=2)
}

